/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jetty.servlet;

import io.bootique.jetty.servlet.ServletEnvironment;
import java.util.Optional;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletRequestEvent;
import javax.servlet.ServletRequestListener;
import javax.servlet.http.HttpServletRequest;

public class DefaultServletEnvironment
implements ServletContextListener,
ServletRequestListener,
ServletEnvironment {
    private ServletContext context;
    private ThreadLocal<HttpServletRequest> request = new ThreadLocal();

    @Override
    public Optional<ServletContext> context() {
        return Optional.ofNullable(this.context);
    }

    @Override
    public Optional<HttpServletRequest> request() {
        return Optional.ofNullable(this.request.get());
    }

    public void contextInitialized(ServletContextEvent sce) {
        this.context = sce.getServletContext();
    }

    public void contextDestroyed(ServletContextEvent sce) {
        this.context = null;
    }

    public void requestInitialized(ServletRequestEvent sre) {
        this.request.set((HttpServletRequest)sre.getServletRequest());
    }

    public void requestDestroyed(ServletRequestEvent sre) {
        this.request.set(null);
    }
}

