/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jetty.server;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.jetty.server.NetworkConnector;

public class ConnectorDescriptor {
    private NetworkConnector connector;

    public ConnectorDescriptor(NetworkConnector connector) {
        this.connector = connector;
    }

    public String getUrl(String context) {
        String protocol = this.getProtocol();
        String host = this.getHost();
        int port = this.getPort(protocol);
        StringBuilder url = new StringBuilder(protocol).append("://").append(host);
        if (port > 0) {
            url.append(":").append(port);
        }
        url.append(context);
        return url.toString();
    }

    private String getProtocol() {
        for (String protocol : this.connector.getProtocols()) {
            if (!"ssl".equals(protocol)) continue;
            return "https";
        }
        return "http";
    }

    private int getPort(String protocol) {
        int port = this.connector.getPort();
        if (port == 80 && "http".equals(protocol)) {
            return 0;
        }
        if (port == 443 && "https".equals(protocol)) {
            return 0;
        }
        return port;
    }

    private String getHost() {
        if (this.connector.getHost() != null) {
            return this.connector.getHost();
        }
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("Error getting localhost", e);
        }
    }
}

