/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.jersey;

import com.google.inject.Binder;
import com.google.inject.Key;
import com.google.inject.multibindings.MapBinder;
import com.google.inject.multibindings.Multibinder;
import io.bootique.ModuleExtender;
import io.bootique.jersey.JerseyResource;
import java.util.Map;
import javax.ws.rs.container.DynamicFeature;
import javax.ws.rs.core.Feature;

public class JerseyModuleExtender
extends ModuleExtender<JerseyModuleExtender> {
    private Multibinder<Feature> features;
    private Multibinder<DynamicFeature> dynamicFeatures;
    private Multibinder<Object> resources;
    private Multibinder<Package> packages;
    private MapBinder<String, Object> properties;

    JerseyModuleExtender(Binder binder) {
        super(binder);
    }

    public JerseyModuleExtender initAllExtensions() {
        this.contributeDynamicFeatures();
        this.contributeFeatures();
        this.contributePackages();
        this.contributeResources();
        this.contributeProperties();
        return this;
    }

    public JerseyModuleExtender addPackage(Package aPackage) {
        this.contributePackages().addBinding().toInstance((Object)aPackage);
        return this;
    }

    public JerseyModuleExtender addPackage(Class<?> anyClassInPackage) {
        this.contributePackages().addBinding().toInstance((Object)anyClassInPackage.getPackage());
        return this;
    }

    public JerseyModuleExtender addFeature(Feature feature) {
        this.contributeFeatures().addBinding().toInstance((Object)feature);
        return this;
    }

    public <T extends Feature> JerseyModuleExtender addFeature(Class<T> featureType) {
        this.contributeFeatures().addBinding().to(featureType);
        return this;
    }

    public JerseyModuleExtender addDynamicFeature(DynamicFeature feature) {
        this.contributeDynamicFeatures().addBinding().toInstance((Object)feature);
        return this;
    }

    public <T extends DynamicFeature> JerseyModuleExtender addDynamicFeature(Class<T> featureType) {
        this.contributeDynamicFeatures().addBinding().to(featureType);
        return this;
    }

    public JerseyModuleExtender addResource(Object resource) {
        this.contributeResources().addBinding().toInstance(resource);
        return this;
    }

    public JerseyModuleExtender addResource(Class<?> resource) {
        this.contributeResources().addBinding().to(resource);
        return this;
    }

    public JerseyModuleExtender setProperty(String name, Object value) {
        this.contributeProperties().addBinding((Object)name).toInstance(value);
        return this;
    }

    public JerseyModuleExtender setProperties(Map<String, String> properties) {
        properties.forEach(this::setProperty);
        return this;
    }

    protected MapBinder<String, Object> contributeProperties() {
        if (this.properties == null) {
            this.properties = this.newMap(String.class, Object.class, JerseyResource.class);
        }
        return this.properties;
    }

    protected Multibinder<Feature> contributeFeatures() {
        if (this.features == null) {
            this.features = this.newSet(Feature.class);
        }
        return this.features;
    }

    protected Multibinder<DynamicFeature> contributeDynamicFeatures() {
        if (this.dynamicFeatures == null) {
            this.dynamicFeatures = this.newSet(DynamicFeature.class);
        }
        return this.dynamicFeatures;
    }

    protected Multibinder<Object> contributeResources() {
        if (this.resources == null) {
            this.resources = this.newSet(Key.get(Object.class, JerseyResource.class));
        }
        return this.resources;
    }

    protected Multibinder<Package> contributePackages() {
        if (this.packages == null) {
            this.packages = this.newSet(Package.class);
        }
        return this.packages;
    }
}

