/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.test.junit;

import io.bootique.BQRuntime;
import io.bootique.command.CommandOutcome;
import io.bootique.test.junit.BQTestRuntimeBuilder;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.rules.ExternalResource;

public class BQTestFactory
extends ExternalResource {
    private Collection<BQRuntime> runtimes;
    private boolean autoLoadModules;

    protected void after() {
        Collection<BQRuntime> localRuntimes = this.runtimes;
        if (localRuntimes != null) {
            localRuntimes.forEach(runtime -> {
                try {
                    runtime.shutdown();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
        }
    }

    protected void before() {
        this.runtimes = new ArrayList<BQRuntime>();
    }

    public BQTestFactory autoLoadModules() {
        this.autoLoadModules = true;
        return this;
    }

    public Builder app(String ... args) {
        Builder builder = new Builder(this.runtimes, args);
        if (this.autoLoadModules) {
            builder.autoLoadModules();
        }
        return builder;
    }

    public static class Builder
    extends BQTestRuntimeBuilder<Builder> {
        private Collection<BQRuntime> runtimes;

        private Builder(Collection<BQRuntime> runtimes, String[] args) {
            super(args);
            this.runtimes = runtimes;
        }

        public BQRuntime createRuntime() {
            BQRuntime runtime = this.bootique.createRuntime();
            this.runtimes.add(runtime);
            return runtime;
        }

        public CommandOutcome run() {
            return this.createRuntime().run();
        }
    }
}

