/*
 * Decompiled with CFR 0.152.
 */
package io.bootique.test.junit;

import io.bootique.BQRuntime;
import io.bootique.BootiqueException;
import io.bootique.command.CommandOutcome;
import io.bootique.log.BootLogger;
import io.bootique.log.DefaultBootLogger;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

public class BQRuntimeDaemon {
    private BootLogger logger = new DefaultBootLogger(false);
    private BQRuntime runtime;
    private long startupTimeout;
    private TimeUnit startupTimeoutTimeUnit;
    private ExecutorService executor;
    private Function<BQRuntime, Boolean> startupCheck;
    private CommandOutcome outcome;

    public BQRuntimeDaemon(BQRuntime runtime, Function<BQRuntime, Boolean> startupCheck, long startupTimeout, TimeUnit startupTimeoutTimeUnit) {
        this.runtime = runtime;
        this.startupCheck = startupCheck;
        this.executor = Executors.newCachedThreadPool();
        this.startupTimeout = startupTimeout;
        this.startupTimeoutTimeUnit = startupTimeoutTimeUnit;
    }

    public Optional<CommandOutcome> getOutcome() {
        return Optional.ofNullable(this.outcome);
    }

    public BQRuntime getRuntime() {
        return this.runtime;
    }

    public void start() {
        this.executor.submit(() -> {
            this.outcome = this.runtime.run();
            return this.outcome;
        });
        this.checkStartupSucceeded(this.startupTimeout, this.startupTimeoutTimeUnit);
    }

    private long startupCheckSleepInterval(long remainingTimeoutMs, int round) {
        long increment = 40L;
        if (remainingTimeoutMs <= 40L) {
            return 40L;
        }
        long sleepFor = 40L + (long)round * 40L;
        return sleepFor < remainingTimeoutMs ? sleepFor : remainingTimeoutMs - 40L;
    }

    private Optional<CommandOutcome> checkStartupOutcome() {
        if (this.outcome != null) {
            return Optional.of(this.outcome);
        }
        if (this.startupCheck.apply(this.runtime).booleanValue()) {
            return Optional.of(CommandOutcome.succeededAndForkedToBackground());
        }
        this.logger.stderr("Daemon runtime hasn't started yet...");
        return Optional.empty();
    }

    protected void checkStartupSucceeded(long timeout, TimeUnit unit) {
        CommandOutcome outcome;
        long startedWaitingMs = System.currentTimeMillis();
        long timeoutMs = unit.toMillis(timeout);
        Future<CommandOutcome> startupFuture = this.executor.submit(() -> {
            try {
                for (int i = 0; i < Integer.MAX_VALUE; ++i) {
                    Optional<CommandOutcome> optOutcome = this.checkStartupOutcome();
                    if (optOutcome.isPresent()) {
                        return optOutcome.get();
                    }
                    long remainingTimeout = timeoutMs - (System.currentTimeMillis() - startedWaitingMs);
                    Thread.sleep(this.startupCheckSleepInterval(remainingTimeout, i));
                }
                return CommandOutcome.failed((int)-1, (String)"Exceeded the number of attempts to check for successful startup");
            }
            catch (InterruptedException e) {
                this.logger.stderr("Interrupted waiting for server to start.. one last check..");
                return this.checkStartupOutcome().orElse(CommandOutcome.failed((int)-1, (Throwable)e));
            }
            catch (Throwable th) {
                this.logger.stderr("Server error", th);
                return CommandOutcome.failed((int)-1, (Throwable)th);
            }
        });
        try {
            outcome = startupFuture.get(timeout, unit);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            throw new RuntimeException(String.format("Daemon failed to start in %s ms", unit.toMillis(timeout)));
        }
        if (!outcome.isSuccess()) {
            throw new BootiqueException(outcome.getExitCode(), "Daemon failed to start: " + outcome);
        }
        this.logger.stderr("Daemon runtime started...");
    }

    public void stop() {
        this.runtime.shutdown();
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(3L, TimeUnit.SECONDS);
            this.logger.stderr("Daemon runtime stopped...");
        }
        catch (InterruptedException e) {
            this.logger.stderr("Interrupted while waiting for shutdown", (Throwable)e);
        }
    }
}

