/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.s3;

import io.awspring.cloud.s3.AbstractTempFileS3OutputStream;
import io.awspring.cloud.s3.Location;
import io.awspring.cloud.s3.ObjectMetadata;
import io.awspring.cloud.s3.S3ObjectContentTypeResolver;
import java.io.IOException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.transfer.s3.S3TransferManager;
import software.amazon.awssdk.transfer.s3.model.UploadFileRequest;

class TransferManagerS3OutputStream
extends AbstractTempFileS3OutputStream {
    private final S3TransferManager s3TransferManager;

    TransferManagerS3OutputStream(Location location, S3TransferManager s3TransferManager, @Nullable ObjectMetadata objectMetadata) throws IOException {
        this(location, s3TransferManager, objectMetadata, null);
    }

    TransferManagerS3OutputStream(Location location, S3TransferManager s3TransferManager, @Nullable ObjectMetadata objectMetadata, @Nullable S3ObjectContentTypeResolver contentTypeResolver) throws IOException {
        super(location, objectMetadata, contentTypeResolver);
        Assert.notNull((Object)s3TransferManager, (String)"s3TransferManager is required");
        this.s3TransferManager = s3TransferManager;
    }

    @Override
    protected void upload(PutObjectRequest putObjectRequest) {
        Assert.notNull((Object)putObjectRequest, (String)"putObjectRequest is required");
        this.s3TransferManager.uploadFile((UploadFileRequest)UploadFileRequest.builder().putObjectRequest(putObjectRequest).source(this.file).build()).completionFuture().join();
    }
}

