/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.s3;

import io.awspring.cloud.s3.Location;
import io.awspring.cloud.s3.ObjectMetadata;
import io.awspring.cloud.s3.S3Exception;
import io.awspring.cloud.s3.S3ObjectConverter;
import io.awspring.cloud.s3.S3Operations;
import io.awspring.cloud.s3.S3OutputStreamProvider;
import io.awspring.cloud.s3.S3Resource;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.time.Duration;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StreamUtils;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.PutObjectRequest;
import software.amazon.awssdk.services.s3.presigner.S3Presigner;
import software.amazon.awssdk.services.s3.presigner.model.GetObjectPresignRequest;
import software.amazon.awssdk.services.s3.presigner.model.PresignedGetObjectRequest;
import software.amazon.awssdk.services.s3.presigner.model.PresignedPutObjectRequest;
import software.amazon.awssdk.services.s3.presigner.model.PutObjectPresignRequest;

public class S3Template
implements S3Operations {
    private final S3Client s3Client;
    private final S3OutputStreamProvider s3OutputStreamProvider;
    private final S3ObjectConverter s3ObjectConverter;
    private final S3Presigner s3Presigner;

    public S3Template(S3Client s3Client, S3OutputStreamProvider s3OutputStreamProvider, S3ObjectConverter s3ObjectConverter, S3Presigner s3Presigner) {
        Assert.notNull((Object)s3Client, (String)"s3Client is required");
        Assert.notNull((Object)s3OutputStreamProvider, (String)"s3OutputStreamProvider is required");
        Assert.notNull((Object)s3ObjectConverter, (String)"s3ObjectConverter is required");
        Assert.notNull((Object)s3Presigner, (String)"s3Presigner is required");
        this.s3Client = s3Client;
        this.s3OutputStreamProvider = s3OutputStreamProvider;
        this.s3ObjectConverter = s3ObjectConverter;
        this.s3Presigner = s3Presigner;
    }

    @Override
    public String createBucket(String bucketName) {
        Assert.notNull((Object)bucketName, (String)"bucketName is required");
        return this.s3Client.createBucket(request -> request.bucket(bucketName)).location();
    }

    @Override
    public void deleteBucket(String bucketName) {
        Assert.notNull((Object)bucketName, (String)"bucketName is required");
        this.s3Client.deleteBucket(request -> request.bucket(bucketName));
    }

    @Override
    public void deleteObject(String bucketName, String key) {
        Assert.notNull((Object)bucketName, (String)"bucketName is required");
        Assert.notNull((Object)key, (String)"key is required");
        this.s3Client.deleteObject(request -> request.bucket(bucketName).key(key));
    }

    @Override
    public void deleteObject(String s3Url) {
        Assert.notNull((Object)s3Url, (String)"s3Url is required");
        Location location = Location.of(s3Url);
        this.deleteObject(location.getBucket(), location.getObject());
    }

    @Override
    public S3Resource store(String bucketName, String key, Object object) {
        Assert.notNull((Object)bucketName, (String)"bucketName is required");
        Assert.notNull((Object)key, (String)"key is required");
        Assert.notNull((Object)object, (String)"object is required");
        PutObjectRequest.Builder requestBuilder = PutObjectRequest.builder().bucket(bucketName).key(key).contentType(this.s3ObjectConverter.contentType());
        this.s3Client.putObject((PutObjectRequest)requestBuilder.build(), this.s3ObjectConverter.write(object));
        return new S3Resource(bucketName, key, this.s3Client, this.s3OutputStreamProvider);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public <T> T read(String bucketName, String key, Class<T> clazz) {
        Assert.notNull((Object)bucketName, (String)"bucketName is required");
        Assert.notNull((Object)key, (String)"key is required");
        Assert.notNull(clazz, (String)"clazz is required");
        try (ResponseInputStream is = this.s3Client.getObject(r -> r.bucket(bucketName).key(key));){
            T t = this.s3ObjectConverter.read((InputStream)is, clazz);
            return t;
        }
        catch (Exception e) {
            throw new S3Exception(String.format("Failed to read object with a key '%s' from bucket '%s'", key, bucketName), e);
        }
    }

    @Override
    public S3Resource upload(String bucketName, String key, InputStream inputStream, @Nullable ObjectMetadata objectMetadata) {
        S3Resource s3Resource;
        block9: {
            Assert.notNull((Object)bucketName, (String)"bucketName is required");
            Assert.notNull((Object)key, (String)"key is required");
            Assert.notNull((Object)inputStream, (String)"inputStream is required");
            S3Resource s3Resource2 = new S3Resource(bucketName, key, this.s3Client, this.s3OutputStreamProvider);
            if (objectMetadata != null) {
                s3Resource2.setObjectMetadata(objectMetadata);
            }
            OutputStream os = s3Resource2.getOutputStream();
            try {
                StreamUtils.copy((InputStream)inputStream, (OutputStream)os);
                s3Resource = s3Resource2;
                if (os == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new S3Exception(String.format("Failed to upload object with a key '%s' to bucket '%s'", key, bucketName), e);
                }
            }
            os.close();
        }
        return s3Resource;
    }

    @Override
    public S3Resource download(String bucketName, String key) {
        Assert.notNull((Object)bucketName, (String)"bucketName is required");
        Assert.notNull((Object)key, (String)"key is required");
        return new S3Resource(bucketName, key, this.s3Client, this.s3OutputStreamProvider);
    }

    @Override
    public URL createSignedGetURL(String bucketName, String key, Duration duration) {
        Assert.notNull((Object)bucketName, (String)"bucketName is required");
        Assert.notNull((Object)key, (String)"key is required");
        Assert.notNull((Object)duration, (String)"duration is required");
        GetObjectRequest getObjectRequest = (GetObjectRequest)GetObjectRequest.builder().bucket(bucketName).key(key).build();
        GetObjectPresignRequest presignRequest = GetObjectPresignRequest.builder().getObjectRequest(getObjectRequest).signatureDuration(duration).build();
        PresignedGetObjectRequest signedRequest = this.s3Presigner.presignGetObject(presignRequest);
        return signedRequest.url();
    }

    @Override
    public URL createSignedPutURL(String bucketName, String key, Duration duration, @Nullable ObjectMetadata metadata, @Nullable String contentType) {
        Assert.notNull((Object)bucketName, (String)"bucketName is required");
        Assert.notNull((Object)key, (String)"key is required");
        Assert.notNull((Object)duration, (String)"duration is required");
        PutObjectRequest.Builder putObjectRequestBuilder = PutObjectRequest.builder().bucket(bucketName).key(key);
        if (metadata != null) {
            putObjectRequestBuilder.metadata(metadata.getMetadata());
        }
        if (contentType != null) {
            putObjectRequestBuilder.contentType(contentType);
        }
        PutObjectRequest putObjectRequest = (PutObjectRequest)putObjectRequestBuilder.build();
        PutObjectPresignRequest presignRequest = PutObjectPresignRequest.builder().putObjectRequest(putObjectRequest).signatureDuration(duration).build();
        PresignedPutObjectRequest signedRequest = this.s3Presigner.presignPutObject(presignRequest);
        return signedRequest.url();
    }
}

