/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.s3;

import io.awspring.cloud.s3.InMemoryBufferingS3OutputStreamProvider;
import io.awspring.cloud.s3.PropertiesS3ObjectContentTypeResolver;
import io.awspring.cloud.s3.S3OutputStreamProvider;
import io.awspring.cloud.s3.S3Resource;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.Bucket;
import software.amazon.awssdk.services.s3.model.ListObjectsV2Request;
import software.amazon.awssdk.services.s3.paginators.ListObjectsV2Iterable;

public class S3PathMatchingResourcePatternResolver
implements ResourcePatternResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(S3PathMatchingResourcePatternResolver.class);
    private final S3Client s3Client;
    private final ResourcePatternResolver resourcePatternResolverDelegate;
    private final PathMatcher pathMatcher;
    private final List<String> wildCardSeparators;
    private final S3OutputStreamProvider s3OutputStreamProvider;

    public S3PathMatchingResourcePatternResolver(S3Client s3Client, ResourcePatternResolver resourcePatternResolverDelegate) {
        this(s3Client, resourcePatternResolverDelegate, new InMemoryBufferingS3OutputStreamProvider(s3Client, new PropertiesS3ObjectContentTypeResolver()));
    }

    public S3PathMatchingResourcePatternResolver(S3Client s3Client, ResourcePatternResolver resourcePatternResolverDelegate, S3OutputStreamProvider s3OutputStreamProvider) {
        this(s3Client, resourcePatternResolverDelegate, s3OutputStreamProvider, (PathMatcher)new AntPathMatcher(), List.of("**", "*", "?"));
    }

    public S3PathMatchingResourcePatternResolver(S3Client s3Client, ResourcePatternResolver resourcePatternResolverDelegate, S3OutputStreamProvider s3OutputStreamProvider, PathMatcher pathMatcher, List<String> wildCardSeparators) {
        Assert.notNull((Object)s3Client, (String)"S3Client must not be null");
        Assert.notNull((Object)resourcePatternResolverDelegate, (String)"ResourcePatternResolver must not be null");
        Assert.notNull((Object)s3OutputStreamProvider, (String)"S3OutputStreamProvider must not be null");
        Assert.notNull((Object)pathMatcher, (String)"PathMatcher must not be null");
        Assert.notNull(wildCardSeparators, (String)"WildCardSeparators must not be null");
        this.s3Client = s3Client;
        this.resourcePatternResolverDelegate = resourcePatternResolverDelegate;
        this.s3OutputStreamProvider = s3OutputStreamProvider;
        this.pathMatcher = pathMatcher;
        this.wildCardSeparators = wildCardSeparators;
    }

    public Resource[] getResources(String locationPattern) throws IOException {
        Assert.notNull((Object)locationPattern, (String)"Location pattern must not be null");
        LOGGER.debug("Get resources of the following location pattern {}", (Object)locationPattern);
        Resource[] resources = locationPattern.toLowerCase().startsWith("s3://") ? this.findResourcesInBucketsWithPatterns(locationPattern) : this.resourcePatternResolverDelegate.getResources(locationPattern);
        String resourceUrisString = Arrays.stream(resources).map(S3PathMatchingResourcePatternResolver::getUriAsString).collect(Collectors.joining(","));
        LOGGER.debug("Found the following resources: {}", (Object)resourceUrisString);
        return resources;
    }

    public Resource getResource(String location) {
        Assert.notNull((Object)location, (String)"Location cannot be null");
        LOGGER.debug("Get resource of the following location {}", (Object)location);
        S3Resource resource = location.toLowerCase().startsWith("s3://") ? this.createS3Resource(location) : this.resourcePatternResolverDelegate.getResource(location);
        LOGGER.debug("Found the following resource: {}", (Object)S3PathMatchingResourcePatternResolver.getUriAsString((Resource)resource));
        return resource;
    }

    public ClassLoader getClassLoader() {
        return this.resourcePatternResolverDelegate.getClassLoader();
    }

    private Resource[] findResourcesInBucketsWithPatterns(String locationPattern) {
        String s3BucketNamePattern = S3PathMatchingResourcePatternResolver.getS3BucketNamePattern(locationPattern);
        LOGGER.debug("The s3 bucket name pattern is {}", (Object)s3BucketNamePattern);
        String s3KeyPattern = S3PathMatchingResourcePatternResolver.substringAfter(locationPattern, s3BucketNamePattern + "/");
        LOGGER.debug("The s3 key pattern is {}", (Object)s3KeyPattern);
        return (Resource[])(this.pathMatcher.isPattern(s3BucketNamePattern) ? this.findMatchingBuckets(s3BucketNamePattern) : List.of(s3BucketNamePattern)).stream().flatMap(s3BucketName -> this.findResourcesInBucketWithKeyPattern((String)s3BucketName, s3KeyPattern).stream()).toArray(Resource[]::new);
    }

    private List<Resource> findResourcesInBucketWithKeyPattern(String s3BucketName, String s3KeyPattern) {
        ListObjectsV2Request listObjectsV2Request = (ListObjectsV2Request)this.getListObjectsV2RequestBuilder(s3BucketName, s3KeyPattern).build();
        LOGGER.debug("Listing objects from bucket {} with prefix: {}", (Object)listObjectsV2Request.bucket(), (Object)listObjectsV2Request.prefix());
        ListObjectsV2Iterable listObjectsV2Iterable = this.s3Client.listObjectsV2Paginator(listObjectsV2Request);
        return listObjectsV2Iterable.stream().flatMap(listObjectsV2Response -> {
            LOGGER.debug("List of s3 objects: {}", (Object)listObjectsV2Response.contents().size());
            return listObjectsV2Response.contents().stream();
        }).filter(s3Object -> {
            boolean s3ObjectKeyMatchesS3KeyPattern = this.pathMatcher.match(s3KeyPattern, s3Object.key());
            LOGGER.debug("The s3 object key ({}) matches the s3 key pattern ({}): {}", new Object[]{s3Object.key(), s3KeyPattern, s3ObjectKeyMatchesS3KeyPattern});
            return s3ObjectKeyMatchesS3KeyPattern;
        }).peek(s3Object -> LOGGER.debug("Resolved key: {} based on pattern: {}", (Object)s3Object.key(), (Object)s3KeyPattern)).map(s3Object -> this.getResource("s3://" + s3BucketName + "/" + s3Object.key())).collect(Collectors.toList());
    }

    private ListObjectsV2Request.Builder getListObjectsV2RequestBuilder(String s3BucketName, String s3KeyPattern) {
        Optional<String> optionalPrefix = this.wildCardSeparators.stream().filter(s3KeyPattern::contains).map(wildcard -> S3PathMatchingResourcePatternResolver.substringBefore(s3KeyPattern, wildcard)).map(s3KeyPatternSubStringBeforeWildCard -> S3PathMatchingResourcePatternResolver.substringBeforeLast(s3KeyPatternSubStringBeforeWildCard, "/")).findFirst();
        ListObjectsV2Request.Builder listObjectsV2RequestBuilder = ListObjectsV2Request.builder().bucket(s3BucketName);
        if (optionalPrefix.isPresent()) {
            listObjectsV2RequestBuilder = listObjectsV2RequestBuilder.prefix(optionalPrefix.get());
        }
        return listObjectsV2RequestBuilder;
    }

    protected S3Resource createS3Resource(String location) {
        LOGGER.debug("Creating resource based on location: {}", (Object)location);
        return Optional.ofNullable(S3Resource.create(location, this.s3Client, this.s3OutputStreamProvider)).orElseThrow(() -> new IllegalStateException("The s3 resource based on the location: " + location + " was not created correctly"));
    }

    private List<String> findMatchingBuckets(String bucketPattern) {
        return this.s3Client.listBuckets().buckets().stream().map(Bucket::name).filter(name -> {
            boolean bucketNameMatchesBucketPattern = this.pathMatcher.match(bucketPattern, name);
            LOGGER.debug("The s3 bucket name ({}) matches the s3 bucket pattern ({}): {}", new Object[]{name, bucketPattern, bucketNameMatchesBucketPattern});
            return bucketNameMatchesBucketPattern;
        }).peek(name -> LOGGER.debug("Resolved bucket name: {} based on pattern: {}", name, (Object)bucketPattern)).collect(Collectors.toList());
    }

    private static String getS3BucketNamePattern(String locationPattern) {
        String locationPatternWithoutS3Scheme = locationPattern.substring("s3://".length());
        return locationPatternWithoutS3Scheme.substring(0, locationPatternWithoutS3Scheme.indexOf(47));
    }

    private static String getUriAsString(Resource resource) {
        try {
            return resource.getURI().toASCIIString();
        }
        catch (IOException e) {
            LOGGER.warn("The URI of the resource couldn't be retrieved", (Throwable)e);
            return "<resource_uri>";
        }
    }

    private static String substringAfter(String str, String separator) {
        if (str.isEmpty() || separator.isEmpty()) {
            return "";
        }
        int pos = str.indexOf(separator);
        return pos == -1 ? "" : str.substring(pos + separator.length());
    }

    private static String substringBefore(String str, String separator) {
        if (str.isEmpty() || separator.isEmpty()) {
            return "";
        }
        int pos = str.indexOf(separator);
        return pos == -1 ? str : str.substring(0, pos);
    }

    private static String substringBeforeLast(String str, String separator) {
        if (str.isEmpty() || separator.isEmpty()) {
            return "";
        }
        int pos = str.lastIndexOf(separator);
        return pos == -1 ? str : str.substring(0, pos);
    }
}

