/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.paramstore;

import com.amazonaws.services.simplesystemsmanagement.AWSSimpleSystemsManagement;
import io.awspring.cloud.paramstore.AwsParamStoreProperties;
import io.awspring.cloud.paramstore.AwsParamStorePropertySource;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AwsParamStorePropertySources {
    private static Log LOG = LogFactory.getLog(AwsParamStorePropertySources.class);
    private final AwsParamStoreProperties properties;

    public AwsParamStorePropertySources(AwsParamStoreProperties properties) {
        this.properties = properties;
    }

    public List<String> getAutomaticContexts(List<String> profiles) {
        ArrayList<String> contexts = new ArrayList<String>();
        String prefix = this.properties.getPrefix();
        String defaultContext = this.getContext(prefix, this.properties.getDefaultContext());
        contexts.add(defaultContext + "/");
        this.addProfiles(contexts, defaultContext, profiles);
        String appName = this.properties.getName();
        String appContext = prefix + "/" + appName;
        contexts.add(appContext + "/");
        this.addProfiles(contexts, appContext, profiles);
        return contexts;
    }

    private String getContext(String prefix, String context) {
        if (prefix != null) {
            return prefix + "/" + context;
        }
        return context;
    }

    private void addProfiles(List<String> contexts, String baseContext, List<String> profiles) {
        for (String profile : profiles) {
            contexts.add(baseContext + this.properties.getProfileSeparator() + profile + "/");
        }
    }

    public AwsParamStorePropertySource createPropertySource(String context, boolean optional, AWSSimpleSystemsManagement client) {
        LOG.info((Object)("Loading property from AWS Parameter Store with name: " + context + ", optional: " + optional));
        try {
            AwsParamStorePropertySource propertySource = new AwsParamStorePropertySource(context, client);
            propertySource.init();
            return propertySource;
        }
        catch (Exception e) {
            if (!optional) {
                throw new AwsParameterPropertySourceNotFoundException(e);
            }
            LOG.warn((Object)("Unable to load AWS parameter from " + context + ". " + e.getMessage()));
            return null;
        }
    }

    static class AwsParameterPropertySourceNotFoundException
    extends RuntimeException {
        AwsParameterPropertySourceNotFoundException(Exception source) {
            super(source);
        }
    }
}

