/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.paramstore;

import io.awspring.cloud.paramstore.ValidationException;
import java.net.URI;
import java.util.regex.Pattern;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="aws.paramstore")
public class AwsParamStoreProperties
implements InitializingBean {
    public static final String CONFIG_PREFIX = "aws.paramstore";
    private static final Pattern PREFIX_PATTERN = Pattern.compile("[a-zA-Z0-9.\\-/]+");
    private static final Pattern PROFILE_SEPARATOR_PATTERN = Pattern.compile("[a-zA-Z0-9.\\-_/\\\\]+");
    private String prefix = "/config";
    private String defaultContext = "application";
    private String profileSeparator = "_";
    private String region;
    private URI endpoint;
    private boolean failFast = true;
    private String name;
    private boolean enabled = true;

    public void afterPropertiesSet() throws Exception {
        if (!StringUtils.hasLength((String)this.defaultContext)) {
            throw new ValidationException("aws.paramstore.defaultContext", "defaultContext should not be empty or null.");
        }
        if (!StringUtils.hasLength((String)this.profileSeparator)) {
            throw new ValidationException("aws.paramstore.profileSeparator", "profileSeparator should not be empty or null.");
        }
        if (StringUtils.hasLength((String)this.prefix) && !PREFIX_PATTERN.matcher(this.prefix).matches()) {
            throw new ValidationException("aws.paramstore.prefix", "The prefix value: " + this.prefix + " must have pattern of: " + PREFIX_PATTERN.toString());
        }
        if (!PROFILE_SEPARATOR_PATTERN.matcher(this.profileSeparator).matches()) {
            throw new ValidationException("aws.paramstore.profileSeparator", "The profileSeparator must have pattern of: " + PROFILE_SEPARATOR_PATTERN.toString());
        }
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public String getDefaultContext() {
        return this.defaultContext;
    }

    public void setDefaultContext(String defaultContext) {
        this.defaultContext = defaultContext;
    }

    public String getProfileSeparator() {
        return this.profileSeparator;
    }

    public void setProfileSeparator(String profileSeparator) {
        this.profileSeparator = profileSeparator;
    }

    public boolean isFailFast() {
        return this.failFast;
    }

    public void setFailFast(boolean failFast) {
        this.failFast = failFast;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(URI endpoint) {
        this.endpoint = endpoint;
    }
}

