/*
 * Decompiled with CFR 0.152.
 */
package io.awspring.cloud.cache.memcached;

import io.awspring.cloud.cache.AbstractCacheFactory;
import io.awspring.cloud.cache.memcached.SimpleSpringMemcached;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.spy.memcached.MemcachedClient;
import net.spy.memcached.MemcachedClientIF;

public class MemcachedCacheFactory
extends AbstractCacheFactory<MemcachedClient> {
    public MemcachedCacheFactory() {
    }

    public MemcachedCacheFactory(Map<String, Integer> expiryTimePerCache, int expiryTime) {
        super(expiryTimePerCache, expiryTime);
    }

    @Override
    public boolean isSupportingCacheArchitecture(String architecture) {
        return "memcached".equals(architecture);
    }

    @Override
    public SimpleSpringMemcached createCache(String cacheName, String host, int port) throws Exception {
        SimpleSpringMemcached springMemcached = new SimpleSpringMemcached((MemcachedClientIF)this.getConnectionFactory(host, port), cacheName);
        springMemcached.setExpiration(this.getExpiryTime(cacheName));
        return springMemcached;
    }

    @Override
    protected MemcachedClient createConnectionClient(String hostName, int port) throws IOException {
        return new MemcachedClient(new InetSocketAddress[]{new InetSocketAddress(hostName, port)});
    }

    @Override
    protected void destroyConnectionClient(MemcachedClient connectionClient) {
        connectionClient.shutdown(10L, TimeUnit.SECONDS);
    }
}

