/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage;

import io.atomix.catalyst.buffer.Buffer;
import io.atomix.catalyst.buffer.FileBuffer;
import io.atomix.catalyst.buffer.HeapBuffer;
import io.atomix.catalyst.buffer.MappedBuffer;
import io.atomix.catalyst.util.Assert;

public final class SegmentDescriptor
implements AutoCloseable {
    public static final int BYTES = 64;
    private static final int ID_LENGTH = 8;
    private static final int VERSION_LENGTH = 8;
    private static final int INDEX_LENGTH = 8;
    private static final int MAX_SIZE_LENGTH = 4;
    private static final int MAX_ENTRIES_LENGTH = 4;
    private static final int UPDATED_LENGTH = 8;
    private static final int LOCKED_LENGTH = 1;
    private static final long ID_POSITION = 0L;
    private static final long VERSION_POSITION = 8L;
    private static final long INDEX_POSITION = 16L;
    private static final long MAX_SIZE_POSITION = 24L;
    private static final long MAX_ENTRIES_POSITION = 28L;
    private static final long UPDATED_POSITION = 32L;
    private static final long LOCKED_POSITION = 40L;
    private Buffer buffer;
    private final long id;
    private final long version;
    private final long index;
    private final long maxSegmentSize;
    private final int maxEntries;
    private volatile long updated;
    private volatile boolean locked;

    public static Builder builder() {
        return new Builder((Buffer)HeapBuffer.allocate((long)64L));
    }

    public static Builder builder(Buffer buffer) {
        return new Builder(buffer);
    }

    public SegmentDescriptor(Buffer buffer) {
        this.buffer = (Buffer)Assert.notNull((Object)buffer, (String)"buffer");
        this.id = buffer.readLong();
        this.version = buffer.readLong();
        this.index = buffer.readLong();
        this.maxSegmentSize = buffer.readUnsignedInt();
        this.maxEntries = buffer.readInt();
        this.updated = buffer.readLong();
        this.locked = buffer.readBoolean();
        buffer.skip(64L - buffer.position());
    }

    public long id() {
        return this.id;
    }

    public long version() {
        return this.version;
    }

    public long index() {
        return this.index;
    }

    public long maxSegmentSize() {
        return this.maxSegmentSize;
    }

    public int maxEntries() {
        return this.maxEntries;
    }

    public long updated() {
        return this.updated;
    }

    public void update(long timestamp) {
        if (!this.locked) {
            this.buffer.writeLong(32L, timestamp);
            this.updated = timestamp;
        }
    }

    public boolean locked() {
        return this.locked;
    }

    public void lock() {
        this.buffer.writeBoolean(40L, true).flush();
        this.locked = true;
    }

    SegmentDescriptor copyTo(Buffer buffer) {
        this.buffer = (Buffer)buffer.writeLong(this.id).writeLong(this.version).writeLong(this.index).writeUnsignedInt(this.maxSegmentSize).writeInt(this.maxEntries).writeLong(this.updated).writeBoolean(this.locked).skip(64L - buffer.position()).flush();
        return this;
    }

    @Override
    public void close() {
        this.buffer.close();
    }

    public void delete() {
        if (this.buffer instanceof FileBuffer) {
            ((FileBuffer)this.buffer).delete();
        } else if (this.buffer instanceof MappedBuffer) {
            ((MappedBuffer)this.buffer).delete();
        }
    }

    public String toString() {
        return String.format("%s[id=%d, version=%d, index=%d, updated=%d, locked=%b]", this.getClass().getSimpleName(), this.id, this.version, this.index, this.updated, this.locked);
    }

    public static class Builder {
        private final Buffer buffer;

        private Builder(Buffer buffer) {
            this.buffer = (Buffer)Assert.notNull((Object)buffer, (String)"buffer");
        }

        public Builder withId(long id) {
            this.buffer.writeLong(0L, id);
            return this;
        }

        public Builder withVersion(long version) {
            this.buffer.writeLong(8L, version);
            return this;
        }

        public Builder withIndex(long index) {
            this.buffer.writeLong(16L, index);
            return this;
        }

        public Builder withMaxSegmentSize(long maxSegmentSize) {
            this.buffer.writeUnsignedInt(24L, maxSegmentSize);
            return this;
        }

        public Builder withMaxEntries(int maxEntries) {
            this.buffer.writeInt(28L, maxEntries);
            return this;
        }

        public SegmentDescriptor build() {
            return new SegmentDescriptor(this.buffer.writeLong(32L, 0L).rewind());
        }
    }
}

