/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.state;

import io.atomix.catalyst.concurrent.NonBlockingFuture;
import io.atomix.catalyst.concurrent.Scheduled;
import io.atomix.catalyst.concurrent.ThreadContext;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.NoOpCommand;
import io.atomix.copycat.Operation;
import io.atomix.copycat.error.ApplicationException;
import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.StateMachineExecutor;
import io.atomix.copycat.server.state.ServerStateMachineContext;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServerStateMachineExecutor
implements StateMachineExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServerStateMachineExecutor.class);
    private final ThreadContext executor;
    private final ServerStateMachineContext context;
    private final Queue<ServerTask> tasks = new ArrayDeque<ServerTask>();
    private final List<ServerScheduledTask> scheduledTasks = new ArrayList<ServerScheduledTask>();
    private final List<ServerScheduledTask> complete = new ArrayList<ServerScheduledTask>();
    private final Map<Class, Function> operations = new HashMap<Class, Function>();
    private long timestamp;

    ServerStateMachineExecutor(ServerStateMachineContext context, ThreadContext executor) {
        this.executor = executor;
        this.context = context;
    }

    long timestamp() {
        return this.timestamp;
    }

    long timestamp(long timestamp) {
        this.timestamp = Math.max(this.timestamp, timestamp);
        return this.timestamp;
    }

    @Override
    public ServerStateMachineContext context() {
        return this.context;
    }

    public Logger logger() {
        return this.executor.logger();
    }

    public Serializer serializer() {
        return this.executor.serializer();
    }

    public Executor executor() {
        return this.executor.executor();
    }

    void init(long index, Instant instant, ServerStateMachineContext.Type type) {
        this.context.update(index, instant, type);
    }

    <T extends Operation<U>, U> U executeOperation(Commit commit) {
        if (commit.operation() instanceof NoOpCommand) {
            commit.close();
            return null;
        }
        Function function = this.operations.get(commit.type());
        if (function == null) {
            for (Map.Entry<Class, Function> entry : this.operations.entrySet()) {
                if (!entry.getKey().isAssignableFrom(commit.type())) continue;
                function = entry.getValue();
                break;
            }
            if (function != null) {
                this.operations.put(commit.type(), function);
            }
        }
        if (function == null) {
            throw new IllegalStateException("unknown state machine operation: " + commit.type());
        }
        try {
            return (U)function.apply(commit);
        }
        catch (Exception e) {
            LOGGER.warn("State machine operation failed: {}", (Throwable)e);
            throw new ApplicationException((Throwable)e, "An application error occurred", new Object[0]);
        }
    }

    void commit() {
        if (!this.tasks.isEmpty()) {
            for (ServerTask task : this.tasks) {
                this.context.update(this.context.index(), this.context.clock().instant(), ServerStateMachineContext.Type.COMMAND);
                try {
                    task.future.complete(task.callback.get());
                }
                catch (Exception e) {
                    task.future.completeExceptionally(e);
                }
            }
            this.tasks.clear();
        }
        this.context.commit();
    }

    void tick(long index, long timestamp) {
        if (!this.scheduledTasks.isEmpty()) {
            ServerScheduledTask task;
            Iterator<ServerScheduledTask> iterator = this.scheduledTasks.iterator();
            while (iterator.hasNext() && (task = iterator.next()).complete(timestamp)) {
                this.context.update(index, Instant.ofEpochMilli(task.time), ServerStateMachineContext.Type.COMMAND);
                task.execute();
                this.complete.add(task);
                iterator.remove();
            }
            for (ServerScheduledTask task2 : this.complete) {
                task2.reschedule();
            }
            this.complete.clear();
        }
    }

    public CompletableFuture<Void> execute(Runnable callback) {
        return this.execute(() -> {
            callback.run();
            return null;
        });
    }

    public <T> CompletableFuture<T> execute(Supplier<T> callback) {
        Assert.state((this.context.type() == ServerStateMachineContext.Type.COMMAND ? 1 : 0) != 0, (String)"callbacks can only be scheduled during command execution", (Object[])new Object[0]);
        NonBlockingFuture future = new NonBlockingFuture();
        this.tasks.add(new ServerTask(callback, (CompletableFuture)future));
        return future;
    }

    public Scheduled schedule(Duration delay, Runnable callback) {
        Assert.state((this.context.type() == ServerStateMachineContext.Type.COMMAND ? 1 : 0) != 0, (String)"callbacks can only be scheduled during command execution", (Object[])new Object[0]);
        LOGGER.trace("Scheduled callback {} with delay {}", (Object)callback, (Object)delay);
        return new ServerScheduledTask(callback, delay.toMillis()).schedule();
    }

    public Scheduled schedule(Duration initialDelay, Duration interval, Runnable callback) {
        Assert.state((this.context.type() == ServerStateMachineContext.Type.COMMAND ? 1 : 0) != 0, (String)"callbacks can only be scheduled during command execution", (Object[])new Object[0]);
        LOGGER.trace("Scheduled repeating callback {} with initial delay {} and interval {}", new Object[]{callback, initialDelay, interval});
        return new ServerScheduledTask(callback, initialDelay.toMillis(), interval.toMillis()).schedule();
    }

    @Override
    public <T extends Operation<Void>> StateMachineExecutor register(Class<T> type, Consumer<Commit<T>> callback) {
        Assert.notNull(type, (String)"type");
        Assert.notNull(callback, (String)"callback");
        this.operations.put(type, commit -> {
            callback.accept((Commit)commit);
            return null;
        });
        LOGGER.trace("Registered void operation callback {}", type);
        return this;
    }

    @Override
    public <T extends Operation<U>, U> StateMachineExecutor register(Class<T> type, Function<Commit<T>, U> callback) {
        Assert.notNull(type, (String)"type");
        Assert.notNull(callback, (String)"callback");
        this.operations.put(type, callback);
        LOGGER.trace("Registered value operation callback {}", type);
        return this;
    }

    @Override
    public void close() {
        this.executor.close();
    }

    private class ServerScheduledTask
    implements Scheduled {
        private final long delay;
        private final long interval;
        private final Runnable callback;
        private long time;

        private ServerScheduledTask(Runnable callback, long delay) {
            this(callback, delay, 0L);
        }

        private ServerScheduledTask(Runnable callback, long delay, long interval) {
            this.delay = delay;
            this.interval = interval;
            this.callback = callback;
            this.time = ServerStateMachineExecutor.this.context.clock().instant().toEpochMilli() + delay;
        }

        private Scheduled schedule() {
            if (!ServerStateMachineExecutor.this.scheduledTasks.isEmpty()) {
                int i;
                int l = 0;
                int u = ServerStateMachineExecutor.this.scheduledTasks.size() - 1;
                while (true) {
                    i = (u + l) / 2;
                    long t = ((ServerScheduledTask)((ServerStateMachineExecutor)ServerStateMachineExecutor.this).scheduledTasks.get((int)i)).time;
                    if (t == this.time) {
                        ServerStateMachineExecutor.this.scheduledTasks.add(i, this);
                        return this;
                    }
                    if (t < this.time) {
                        l = i + 1;
                        if (l <= u) continue;
                        ServerStateMachineExecutor.this.scheduledTasks.add(i + 1, this);
                        return this;
                    }
                    u = i - 1;
                    if (l > u) break;
                }
                ServerStateMachineExecutor.this.scheduledTasks.add(i, this);
                return this;
            }
            ServerStateMachineExecutor.this.scheduledTasks.add(this);
            return this;
        }

        private void reschedule() {
            if (this.interval > 0L) {
                this.time = ServerStateMachineExecutor.this.timestamp + this.interval;
                this.schedule();
            }
        }

        private boolean complete(long timestamp) {
            return timestamp > this.time;
        }

        private synchronized void execute() {
            this.callback.run();
        }

        public synchronized void cancel() {
            ServerStateMachineExecutor.this.scheduledTasks.remove(this);
        }
    }

    private static class ServerTask {
        private final Supplier callback;
        private final CompletableFuture future;

        private ServerTask(Supplier callback, CompletableFuture future) {
            this.callback = callback;
            this.future = future;
        }
    }
}

