/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.state;

import io.atomix.catalyst.concurrent.Scheduled;
import io.atomix.catalyst.transport.Connection;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.Command;
import io.atomix.copycat.Query;
import io.atomix.copycat.error.CopycatError;
import io.atomix.copycat.error.CopycatException;
import io.atomix.copycat.protocol.CommandRequest;
import io.atomix.copycat.protocol.CommandResponse;
import io.atomix.copycat.protocol.ConnectRequest;
import io.atomix.copycat.protocol.ConnectResponse;
import io.atomix.copycat.protocol.KeepAliveRequest;
import io.atomix.copycat.protocol.KeepAliveResponse;
import io.atomix.copycat.protocol.QueryRequest;
import io.atomix.copycat.protocol.QueryResponse;
import io.atomix.copycat.protocol.RegisterRequest;
import io.atomix.copycat.protocol.RegisterResponse;
import io.atomix.copycat.protocol.Response;
import io.atomix.copycat.protocol.UnregisterRequest;
import io.atomix.copycat.protocol.UnregisterResponse;
import io.atomix.copycat.server.CopycatServer;
import io.atomix.copycat.server.cluster.Member;
import io.atomix.copycat.server.protocol.AppendRequest;
import io.atomix.copycat.server.protocol.AppendResponse;
import io.atomix.copycat.server.protocol.JoinRequest;
import io.atomix.copycat.server.protocol.JoinResponse;
import io.atomix.copycat.server.protocol.LeaveRequest;
import io.atomix.copycat.server.protocol.LeaveResponse;
import io.atomix.copycat.server.protocol.PollRequest;
import io.atomix.copycat.server.protocol.PollResponse;
import io.atomix.copycat.server.protocol.ReconfigureRequest;
import io.atomix.copycat.server.protocol.ReconfigureResponse;
import io.atomix.copycat.server.protocol.VoteRequest;
import io.atomix.copycat.server.protocol.VoteResponse;
import io.atomix.copycat.server.state.ActiveState;
import io.atomix.copycat.server.state.LeaderAppender;
import io.atomix.copycat.server.state.MemberState;
import io.atomix.copycat.server.state.ServerContext;
import io.atomix.copycat.server.state.ServerMember;
import io.atomix.copycat.server.state.ServerSessionContext;
import io.atomix.copycat.server.state.ServerState;
import io.atomix.copycat.server.state.ServerStateMachine;
import io.atomix.copycat.server.storage.entry.CommandEntry;
import io.atomix.copycat.server.storage.entry.ConfigurationEntry;
import io.atomix.copycat.server.storage.entry.InitializeEntry;
import io.atomix.copycat.server.storage.entry.KeepAliveEntry;
import io.atomix.copycat.server.storage.entry.QueryEntry;
import io.atomix.copycat.server.storage.entry.RegisterEntry;
import io.atomix.copycat.server.storage.entry.UnregisterEntry;
import io.atomix.copycat.server.storage.system.Configuration;
import io.atomix.copycat.session.Session;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.stream.Collectors;

final class LeaderState
extends ActiveState {
    private final LeaderAppender appender = new LeaderAppender(this);
    private Scheduled appendTimer;
    private long configuring;

    public LeaderState(ServerContext context) {
        super(context);
    }

    @Override
    public CopycatServer.State type() {
        return CopycatServer.State.LEADER;
    }

    @Override
    public synchronized CompletableFuture<ServerState> open() {
        this.takeLeadership();
        this.appendInitialEntries();
        this.commitInitialEntries();
        return ((CompletableFuture)super.open().thenRun(this::startAppendTimer)).thenApply(v -> this);
    }

    private void takeLeadership() {
        this.context.setLeader(this.context.getCluster().member().id());
        this.context.getClusterState().getRemoteMemberStates().forEach(m -> m.resetState(this.context.getLog()));
    }

    private void appendInitialEntries() {
        long term = this.context.getTerm();
        try (InitializeEntry entry = this.context.getLog().create(InitializeEntry.class);){
            ((InitializeEntry)entry.setTerm(term)).setTimestamp(this.appender.time());
            Assert.state((this.context.getLog().append(entry) == this.appender.index() ? 1 : 0) != 0, (String)"Initialize entry not appended at the start of the leader's term", (Object[])new Object[0]);
            this.LOGGER.trace("{} - Appended {}", (Object)this.context.getCluster().member().address(), (Object)entry);
        }
        this.configure(this.context.getCluster().members());
    }

    private CompletableFuture<Void> commitInitialEntries() {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.appender.appendEntries(this.appender.index()).whenComplete((resultIndex, error) -> {
            this.context.checkThread();
            if (this.isOpen()) {
                if (error == null) {
                    this.context.getStateMachine().apply((long)resultIndex);
                    future.complete(null);
                } else {
                    this.context.setLeader(0);
                    this.context.transition(CopycatServer.State.FOLLOWER);
                }
            }
        });
        return future;
    }

    private void startAppendTimer() {
        this.LOGGER.trace("{} - Starting append timer", (Object)this.context.getCluster().member().address());
        this.appendTimer = this.context.getThreadContext().schedule(Duration.ZERO, this.context.getHeartbeatInterval(), this::appendMembers);
    }

    private void appendMembers() {
        this.context.checkThread();
        if (this.isOpen()) {
            this.appender.appendEntries();
        }
    }

    private void checkSessions() {
        long term = this.context.getTerm();
        for (ServerSessionContext session : this.context.getStateMachine().executor().context().sessions().sessions.values()) {
            long index;
            if (session.state() != Session.State.UNSTABLE || session.isUnregistering()) continue;
            this.LOGGER.debug("{} - Detected expired session: {}", (Object)this.context.getCluster().member().address(), (Object)session.id());
            try (UnregisterEntry entry = this.context.getLog().create(UnregisterEntry.class);){
                ((UnregisterEntry)((UnregisterEntry)entry.setTerm(term)).setSession(session.id())).setExpired(true).setTimestamp(System.currentTimeMillis());
                index = this.context.getLog().append(entry);
                this.LOGGER.trace("{} - Appended {}", (Object)this.context.getCluster().member().address(), (Object)entry);
            }
            this.appender.appendEntries(index).whenComplete((result, error) -> {
                if (this.isOpen()) {
                    this.context.getStateMachine().apply(index);
                }
            });
            session.unregister();
        }
    }

    boolean configuring() {
        return this.configuring > 0L;
    }

    boolean initializing() {
        return this.appender.index() == 0L || this.context.getCommitIndex() < this.appender.index();
    }

    protected CompletableFuture<Long> configure(Collection<Member> members) {
        long index;
        try (ConfigurationEntry entry = this.context.getLog().create(ConfigurationEntry.class);){
            ((ConfigurationEntry)((ConfigurationEntry)entry.setTerm(this.context.getTerm())).setTimestamp(System.currentTimeMillis())).setMembers(members);
            index = this.context.getLog().append(entry);
            this.LOGGER.trace("{} - Appended {}", (Object)this.context.getCluster().member().address(), (Object)entry);
            this.configuring = index;
            this.context.getClusterState().configure(new Configuration(entry.getIndex(), entry.getTerm(), entry.getTimestamp(), entry.getMembers()));
        }
        return this.appender.appendEntries(index).whenComplete((commitIndex, commitError) -> {
            this.context.checkThread();
            if (this.isOpen()) {
                this.configuring = 0L;
            }
        });
    }

    @Override
    public CompletableFuture<JoinResponse> join(JoinRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        if (this.configuring() || this.initializing()) {
            return CompletableFuture.completedFuture(this.logResponse(((JoinResponse.Builder)JoinResponse.builder().withStatus(Response.Status.ERROR)).build()));
        }
        if (this.context.getCluster().member(request.member().id()) != null) {
            return CompletableFuture.completedFuture(this.logResponse(((JoinResponse.Builder)((Object)((JoinResponse.Builder)((Object)((JoinResponse.Builder)((Object)((JoinResponse.Builder)((Object)((JoinResponse.Builder)JoinResponse.builder().withStatus(Response.Status.OK)).withIndex(this.context.getClusterState().getConfiguration().index()))).withTerm(this.context.getClusterState().getConfiguration().term()))).withTime(this.context.getClusterState().getConfiguration().time()))).withMembers(this.context.getCluster().members()))).build()));
        }
        Member member = request.member();
        Collection<Member> members = this.context.getCluster().members();
        members.add(new ServerMember(member.type(), member.serverAddress(), member.clientAddress(), Instant.now()));
        CompletableFuture<JoinResponse> future = new CompletableFuture<JoinResponse>();
        this.configure(members).whenComplete((index, error) -> {
            this.context.checkThread();
            if (this.isOpen()) {
                if (error == null) {
                    future.complete((JoinResponse)this.logResponse(((JoinResponse.Builder)((Object)((Object)((JoinResponse.Builder)((Object)((Object)((JoinResponse.Builder)((Object)((Object)((JoinResponse.Builder)((Object)((Object)((JoinResponse.Builder)JoinResponse.builder().withStatus(Response.Status.OK)).withIndex((long)index)))).withTerm(this.context.getClusterState().getConfiguration().term())))).withTime(this.context.getClusterState().getConfiguration().time())))).withMembers(members)))).build()));
                } else {
                    future.complete((JoinResponse)this.logResponse(((JoinResponse.Builder)((JoinResponse.Builder)JoinResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)CopycatError.Type.INTERNAL_ERROR)).build()));
                }
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<ReconfigureResponse> reconfigure(ReconfigureRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        if (this.configuring() || this.initializing()) {
            return CompletableFuture.completedFuture(this.logResponse(((ReconfigureResponse.Builder)ReconfigureResponse.builder().withStatus(Response.Status.ERROR)).build()));
        }
        ServerMember existingMember = this.context.getClusterState().member(request.member().id());
        if (existingMember == null) {
            return CompletableFuture.completedFuture(this.logResponse(((ReconfigureResponse.Builder)((ReconfigureResponse.Builder)ReconfigureResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)CopycatError.Type.UNKNOWN_SESSION_ERROR)).build()));
        }
        if (request.index() > 0L && request.index() < this.context.getClusterState().getConfiguration().index() || request.term() != this.context.getClusterState().getConfiguration().term() && (existingMember.type() != request.member().type() || existingMember.status() != request.member().status())) {
            return CompletableFuture.completedFuture(this.logResponse(((ReconfigureResponse.Builder)((ReconfigureResponse.Builder)ReconfigureResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)CopycatError.Type.CONFIGURATION_ERROR)).build()));
        }
        Member member = request.member();
        if (!(member.clientAddress() == null || existingMember.clientAddress() != null && existingMember.clientAddress().equals((Object)member.clientAddress()))) {
            existingMember.update(member.clientAddress(), Instant.now());
        }
        existingMember.update(request.member().type(), Instant.now());
        Collection<Member> members = this.context.getCluster().members();
        CompletableFuture<ReconfigureResponse> future = new CompletableFuture<ReconfigureResponse>();
        this.configure(members).whenComplete((index, error) -> {
            this.context.checkThread();
            if (this.isOpen()) {
                if (error == null) {
                    future.complete((ReconfigureResponse)this.logResponse(((ReconfigureResponse.Builder)((Object)((Object)((ReconfigureResponse.Builder)((Object)((Object)((ReconfigureResponse.Builder)((Object)((Object)((ReconfigureResponse.Builder)((Object)((Object)((ReconfigureResponse.Builder)ReconfigureResponse.builder().withStatus(Response.Status.OK)).withIndex((long)index)))).withTerm(this.context.getClusterState().getConfiguration().term())))).withTime(this.context.getClusterState().getConfiguration().time())))).withMembers(members)))).build()));
                } else {
                    future.complete((ReconfigureResponse)this.logResponse(((ReconfigureResponse.Builder)((ReconfigureResponse.Builder)ReconfigureResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)CopycatError.Type.INTERNAL_ERROR)).build()));
                }
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<LeaveResponse> leave(LeaveRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        if (this.configuring() || this.initializing()) {
            return CompletableFuture.completedFuture(this.logResponse(((LeaveResponse.Builder)LeaveResponse.builder().withStatus(Response.Status.ERROR)).build()));
        }
        if (this.context.getCluster().member(request.member().id()) == null) {
            return CompletableFuture.completedFuture(this.logResponse(((LeaveResponse.Builder)((Object)((LeaveResponse.Builder)LeaveResponse.builder().withStatus(Response.Status.OK)).withMembers(this.context.getCluster().members()))).build()));
        }
        Member member = request.member();
        Collection<Member> members = this.context.getCluster().members();
        members.remove(member);
        CompletableFuture<LeaveResponse> future = new CompletableFuture<LeaveResponse>();
        this.configure(members).whenComplete((index, error) -> {
            this.context.checkThread();
            if (this.isOpen()) {
                if (error == null) {
                    future.complete((LeaveResponse)this.logResponse(((LeaveResponse.Builder)((Object)((Object)((LeaveResponse.Builder)((Object)((Object)((LeaveResponse.Builder)((Object)((Object)((LeaveResponse.Builder)((Object)((Object)((LeaveResponse.Builder)LeaveResponse.builder().withStatus(Response.Status.OK)).withIndex((long)index)))).withTerm(this.context.getClusterState().getConfiguration().term())))).withTime(this.context.getClusterState().getConfiguration().time())))).withMembers(members)))).build()));
                } else {
                    future.complete((LeaveResponse)this.logResponse(((LeaveResponse.Builder)((LeaveResponse.Builder)LeaveResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)CopycatError.Type.INTERNAL_ERROR)).build()));
                }
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<PollResponse> poll(PollRequest request) {
        this.logRequest(request);
        MemberState member = this.context.getClusterState().getMemberState(request.candidate());
        if (member != null) {
            member.resetFailureCount();
            if (member.getMember().status() == Member.Status.UNAVAILABLE) {
                member.getMember().update(Member.Status.AVAILABLE, Instant.now());
                this.configure(this.context.getCluster().members());
            }
        }
        return CompletableFuture.completedFuture(this.logResponse(((PollResponse.Builder)PollResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withAccepted(false).build()));
    }

    @Override
    public CompletableFuture<VoteResponse> vote(VoteRequest request) {
        if (this.updateTermAndLeader(request.term(), 0)) {
            this.LOGGER.debug("{} - Received greater term", (Object)this.context.getCluster().member().address());
            this.context.transition(CopycatServer.State.FOLLOWER);
            return super.vote(request);
        }
        this.logRequest(request);
        return CompletableFuture.completedFuture(this.logResponse(((VoteResponse.Builder)VoteResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withVoted(false).build()));
    }

    @Override
    public CompletableFuture<AppendResponse> append(AppendRequest request) {
        this.context.checkThread();
        if (this.updateTermAndLeader(request.term(), request.leader())) {
            CompletableFuture<AppendResponse> future = super.append(request);
            this.context.transition(CopycatServer.State.FOLLOWER);
            return future;
        }
        if (request.term() < this.context.getTerm()) {
            this.logRequest(request);
            return CompletableFuture.completedFuture(this.logResponse(((AppendResponse.Builder)AppendResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withSucceeded(false).withLogIndex(this.context.getLog().lastIndex()).build()));
        }
        this.context.setLeader(request.leader()).transition(CopycatServer.State.FOLLOWER);
        return super.append(request);
    }

    @Override
    public CompletableFuture<CommandResponse> command(CommandRequest request) {
        long index;
        this.context.checkThread();
        this.logRequest(request);
        ServerSessionContext session = this.context.getStateMachine().executor().context().sessions().getSession(request.session());
        if (session == null) {
            return CompletableFuture.completedFuture(this.logResponse(((CommandResponse.Builder)((CommandResponse.Builder)CommandResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)CopycatError.Type.UNKNOWN_SESSION_ERROR)).build()));
        }
        if (!session.setRequestSequence(request.sequence())) {
            return CompletableFuture.completedFuture(this.logResponse(((CommandResponse.Builder)((CommandResponse.Builder)((CommandResponse.Builder)CommandResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)CopycatError.Type.COMMAND_ERROR)).withLastSequence(session.getRequestSequence())).build()));
        }
        CompletableFuture future = new CompletableFuture();
        Command command = request.command();
        long term = this.context.getTerm();
        long timestamp = System.currentTimeMillis();
        try (CommandEntry entry = this.context.getLog().create(CommandEntry.class);){
            ((CommandEntry)((CommandEntry)((CommandEntry)((CommandEntry)entry.setTerm(term)).setSession(request.session())).setTimestamp(timestamp)).setSequence(request.sequence())).setCommand(command);
            index = this.context.getLog().append(entry);
            this.LOGGER.trace("{} - Appended {}", (Object)this.context.getCluster().member().address(), (Object)entry);
        }
        this.appender.appendEntries(index).whenComplete((commitIndex, commitError) -> {
            this.context.checkThread();
            if (this.isOpen()) {
                if (commitError == null) {
                    this.context.getStateMachine().apply(index).whenComplete((result, error) -> {
                        if (this.isOpen()) {
                            this.completeOperation((ServerStateMachine.Result)result, CommandResponse.builder(), (Throwable)error, future);
                        }
                    });
                } else {
                    future.complete(((CommandResponse.Builder)((CommandResponse.Builder)CommandResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)CopycatError.Type.INTERNAL_ERROR)).build());
                }
            }
        });
        return future.thenApply(this::logResponse);
    }

    @Override
    public CompletableFuture<QueryResponse> query(QueryRequest request) {
        Query query = request.query();
        long timestamp = System.currentTimeMillis();
        this.context.checkThread();
        this.logRequest(request);
        QueryEntry entry = ((QueryEntry)((QueryEntry)((QueryEntry)((QueryEntry)((QueryEntry)this.context.getLog().create(QueryEntry.class).setIndex(request.index())).setTerm(this.context.getTerm())).setTimestamp(timestamp)).setSession(request.session())).setSequence(request.sequence())).setQuery(query);
        return this.query(entry).thenApply(this::logResponse);
    }

    private CompletableFuture<QueryResponse> query(QueryEntry entry) {
        Query.ConsistencyLevel consistency = entry.getQuery().consistency();
        if (consistency == null) {
            return this.queryLinearizable(entry);
        }
        switch (consistency) {
            case SEQUENTIAL: {
                return this.queryLocal(entry);
            }
            case LINEARIZABLE_LEASE: {
                return this.queryBoundedLinearizable(entry);
            }
            case LINEARIZABLE: {
                return this.queryLinearizable(entry);
            }
        }
        throw new IllegalStateException("unknown consistency level");
    }

    private CompletableFuture<QueryResponse> queryBoundedLinearizable(QueryEntry entry) {
        return this.sequenceAndApply(entry);
    }

    private CompletableFuture<QueryResponse> queryLinearizable(QueryEntry entry) {
        return this.sequenceAndApply(entry).thenCompose(response -> ((CompletableFuture)this.appender.appendEntries().thenApply(index -> response)).exceptionally(error -> (QueryResponse)((QueryResponse.Builder)((QueryResponse.Builder)QueryResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)CopycatError.Type.QUERY_ERROR)).build()));
    }

    private CompletableFuture<QueryResponse> sequenceAndApply(QueryEntry entry) {
        ServerSessionContext session = this.context.getStateMachine().executor().context().sessions().getSession(entry.getSession());
        if (session == null) {
            return CompletableFuture.completedFuture(this.logResponse(((QueryResponse.Builder)((QueryResponse.Builder)QueryResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)CopycatError.Type.UNKNOWN_SESSION_ERROR)).build()));
        }
        CompletableFuture<QueryResponse> future = new CompletableFuture<QueryResponse>();
        if (entry.getSequence() > session.getCommandSequence()) {
            session.registerSequenceQuery(entry.getSequence(), () -> this.applyQuery(entry, future));
        } else {
            this.applyQuery(entry, future);
        }
        return future;
    }

    @Override
    public CompletableFuture<RegisterResponse> register(RegisterRequest request) {
        long index;
        long timestamp = System.currentTimeMillis();
        long timeout = request.timeout() != 0L ? request.timeout() : this.context.getSessionTimeout().toMillis();
        this.context.checkThread();
        this.logRequest(request);
        try (RegisterEntry entry = this.context.getLog().create(RegisterEntry.class);){
            ((RegisterEntry)((RegisterEntry)entry.setTerm(this.context.getTerm())).setTimestamp(timestamp)).setClient(request.client()).setTimeout(timeout);
            index = this.context.getLog().append(entry);
            this.LOGGER.trace("{} - Appended {}", (Object)this.context.getCluster().member().address(), (Object)entry);
        }
        CompletableFuture<RegisterResponse> future = new CompletableFuture<RegisterResponse>();
        this.appender.appendEntries(index).whenComplete((commitIndex, commitError) -> {
            this.context.checkThread();
            if (this.isOpen()) {
                if (commitError == null) {
                    this.context.getStateMachine().apply(index).whenComplete((sessionId, sessionError) -> {
                        if (this.isOpen()) {
                            if (sessionError == null) {
                                future.complete(this.logResponse(((RegisterResponse.Builder)RegisterResponse.builder().withStatus(Response.Status.OK)).withSession(((Long)sessionId).longValue()).withTimeout(timeout).withLeader(this.context.getCluster().member().clientAddress()).withMembers((Collection)this.context.getCluster().members().stream().map(Member::clientAddress).filter(m -> m != null).collect(Collectors.toList())).build()));
                            } else if (sessionError instanceof CompletionException && sessionError.getCause() instanceof CopycatException) {
                                future.complete(this.logResponse(((RegisterResponse.Builder)((RegisterResponse.Builder)RegisterResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)((CopycatException)sessionError.getCause()).getType())).build()));
                            } else if (sessionError instanceof CopycatException) {
                                future.complete(this.logResponse(((RegisterResponse.Builder)((RegisterResponse.Builder)RegisterResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)((CopycatException)sessionError).getType())).build()));
                            } else {
                                future.complete(this.logResponse(((RegisterResponse.Builder)((RegisterResponse.Builder)RegisterResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)CopycatError.Type.INTERNAL_ERROR)).build()));
                            }
                            this.checkSessions();
                        }
                    });
                } else {
                    future.complete(this.logResponse(((RegisterResponse.Builder)((RegisterResponse.Builder)RegisterResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)CopycatError.Type.INTERNAL_ERROR)).build()));
                }
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<ConnectResponse> connect(ConnectRequest request, Connection connection) {
        this.context.checkThread();
        this.logRequest(request);
        this.context.getStateMachine().executor().context().sessions().registerConnection(request.client(), connection);
        return CompletableFuture.completedFuture(((ConnectResponse.Builder)ConnectResponse.builder().withStatus(Response.Status.OK)).withLeader(this.context.getCluster().member().clientAddress()).withMembers((Collection)this.context.getCluster().members().stream().map(Member::clientAddress).filter(m -> m != null).collect(Collectors.toList())).build()).thenApply(this::logResponse);
    }

    @Override
    public CompletableFuture<KeepAliveResponse> keepAlive(KeepAliveRequest request) {
        long index;
        long timestamp = System.currentTimeMillis();
        this.context.checkThread();
        this.logRequest(request);
        try (KeepAliveEntry entry = this.context.getLog().create(KeepAliveEntry.class);){
            ((KeepAliveEntry)((KeepAliveEntry)entry.setTerm(this.context.getTerm())).setSession(request.session())).setCommandSequence(request.commandSequence()).setEventIndex(request.eventIndex()).setTimestamp(timestamp);
            index = this.context.getLog().append(entry);
            this.LOGGER.trace("{} - Appended {}", (Object)this.context.getCluster().member().address(), (Object)entry);
        }
        CompletableFuture<KeepAliveResponse> future = new CompletableFuture<KeepAliveResponse>();
        this.appender.appendEntries(index).whenComplete((commitIndex, commitError) -> {
            this.context.checkThread();
            if (this.isOpen()) {
                if (commitError == null) {
                    this.context.getStateMachine().apply(index).whenComplete((sessionResult, sessionError) -> {
                        if (this.isOpen()) {
                            if (sessionError == null) {
                                future.complete(this.logResponse(((KeepAliveResponse.Builder)KeepAliveResponse.builder().withStatus(Response.Status.OK)).withLeader(this.context.getCluster().member().clientAddress()).withMembers((Collection)this.context.getCluster().members().stream().map(Member::clientAddress).filter(m -> m != null).collect(Collectors.toList())).build()));
                            } else if (sessionError instanceof CompletionException && sessionError.getCause() instanceof CopycatException) {
                                future.complete(this.logResponse(((KeepAliveResponse.Builder)((KeepAliveResponse.Builder)KeepAliveResponse.builder().withStatus(Response.Status.ERROR)).withLeader(this.context.getCluster().member().clientAddress()).withError((CopycatError)((CopycatException)sessionError.getCause()).getType())).build()));
                            } else if (sessionError instanceof CopycatException) {
                                future.complete(this.logResponse(((KeepAliveResponse.Builder)((KeepAliveResponse.Builder)KeepAliveResponse.builder().withStatus(Response.Status.ERROR)).withLeader(this.context.getCluster().member().clientAddress()).withError((CopycatError)((CopycatException)sessionError).getType())).build()));
                            } else {
                                future.complete(this.logResponse(((KeepAliveResponse.Builder)((KeepAliveResponse.Builder)KeepAliveResponse.builder().withStatus(Response.Status.ERROR)).withLeader(this.context.getCluster().member().clientAddress()).withError((CopycatError)CopycatError.Type.INTERNAL_ERROR)).build()));
                            }
                            this.checkSessions();
                        }
                    });
                } else {
                    future.complete(this.logResponse(((KeepAliveResponse.Builder)((KeepAliveResponse.Builder)KeepAliveResponse.builder().withStatus(Response.Status.ERROR)).withLeader(this.context.getCluster().member().clientAddress()).withError((CopycatError)CopycatError.Type.INTERNAL_ERROR)).build()));
                }
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<UnregisterResponse> unregister(UnregisterRequest request) {
        long index;
        long timestamp = System.currentTimeMillis();
        this.context.checkThread();
        this.logRequest(request);
        try (UnregisterEntry entry = this.context.getLog().create(UnregisterEntry.class);){
            ((UnregisterEntry)((UnregisterEntry)entry.setTerm(this.context.getTerm())).setSession(request.session())).setExpired(false).setTimestamp(timestamp);
            index = this.context.getLog().append(entry);
            this.LOGGER.trace("{} - Appended {}", (Object)this.context.getCluster().member().address(), (Object)entry);
        }
        CompletableFuture<UnregisterResponse> future = new CompletableFuture<UnregisterResponse>();
        this.appender.appendEntries(index).whenComplete((commitIndex, commitError) -> {
            this.context.checkThread();
            if (this.isOpen()) {
                if (commitError == null) {
                    this.context.getStateMachine().apply(index).whenComplete((unregisterResult, unregisterError) -> {
                        if (this.isOpen()) {
                            if (unregisterError == null) {
                                future.complete((UnregisterResponse)this.logResponse(((UnregisterResponse.Builder)UnregisterResponse.builder().withStatus(Response.Status.OK)).build()));
                            } else if (unregisterError instanceof CompletionException && unregisterError.getCause() instanceof CopycatException) {
                                future.complete((UnregisterResponse)this.logResponse(((UnregisterResponse.Builder)((UnregisterResponse.Builder)UnregisterResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)((CopycatException)unregisterError.getCause()).getType())).build()));
                            } else if (unregisterError instanceof CopycatException) {
                                future.complete((UnregisterResponse)this.logResponse(((UnregisterResponse.Builder)((UnregisterResponse.Builder)UnregisterResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)((CopycatException)unregisterError).getType())).build()));
                            } else {
                                future.complete((UnregisterResponse)this.logResponse(((UnregisterResponse.Builder)((UnregisterResponse.Builder)UnregisterResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)CopycatError.Type.INTERNAL_ERROR)).build()));
                            }
                            this.checkSessions();
                        }
                    });
                } else {
                    future.complete((UnregisterResponse)this.logResponse(((UnregisterResponse.Builder)((UnregisterResponse.Builder)UnregisterResponse.builder().withStatus(Response.Status.ERROR)).withError((CopycatError)CopycatError.Type.INTERNAL_ERROR)).build()));
                }
            }
        });
        return future;
    }

    private void cancelAppendTimer() {
        if (this.appendTimer != null) {
            this.LOGGER.trace("{} - Cancelling append timer", (Object)this.context.getCluster().member().address());
            this.appendTimer.cancel();
        }
    }

    private void stepDown() {
        if (this.context.getLeader() != null && this.context.getLeader().equals(this.context.getCluster().member())) {
            this.context.setLeader(0);
        }
    }

    @Override
    public synchronized CompletableFuture<Void> close() {
        return ((CompletableFuture)((CompletableFuture)super.close().thenRun(this.appender::close)).thenRun(this::cancelAppendTimer)).thenRun(this::stepDown);
    }
}

