/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.util;

import io.atomix.catalyst.buffer.util.BitArray;
import io.atomix.catalyst.util.Assert;
import java.util.function.Predicate;

public final class OffsetPredicate
implements Predicate<Long>,
AutoCloseable {
    private final BitArray bits;

    public OffsetPredicate() {
        this(BitArray.allocate((long)1024L));
    }

    OffsetPredicate(BitArray bits) {
        this.bits = (BitArray)Assert.notNull((Object)bits, (String)"bits");
    }

    @Override
    public boolean test(Long offset) {
        return offset != -1L && (this.bits.size() <= offset || !this.bits.get(offset.longValue()));
    }

    public boolean release(long offset) {
        Assert.argNot((offset < 0L ? 1 : 0) != 0, (String)"offset must be positive", (Object[])new Object[0]);
        if (this.bits.size() <= offset) {
            while (this.bits.size() <= offset) {
                this.bits.resize(this.bits.size() * 2L);
            }
        }
        return this.bits.set(offset);
    }

    public long count() {
        return this.bits.count();
    }

    public OffsetPredicate copy() {
        return new OffsetPredicate(this.bits.copy());
    }

    @Override
    public void close() {
        this.bits.close();
    }
}

