/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.snapshot;

import io.atomix.catalyst.buffer.HeapBuffer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.server.storage.snapshot.Snapshot;
import io.atomix.copycat.server.storage.snapshot.SnapshotDescriptor;
import io.atomix.copycat.server.storage.snapshot.SnapshotReader;
import io.atomix.copycat.server.storage.snapshot.SnapshotStore;
import io.atomix.copycat.server.storage.snapshot.SnapshotWriter;

final class MemorySnapshot
extends Snapshot {
    private final HeapBuffer buffer;
    private final SnapshotDescriptor descriptor;
    private final SnapshotStore store;

    MemorySnapshot(HeapBuffer buffer, SnapshotDescriptor descriptor, SnapshotStore store) {
        super(store);
        buffer.mark();
        this.buffer = (HeapBuffer)Assert.notNull((Object)buffer, (String)"buffer");
        this.buffer.position(64L).mark();
        this.descriptor = (SnapshotDescriptor)Assert.notNull((Object)descriptor, (String)"descriptor");
        this.store = (SnapshotStore)Assert.notNull((Object)store, (String)"store");
    }

    @Override
    public long index() {
        return this.descriptor.index();
    }

    @Override
    public long timestamp() {
        return this.descriptor.timestamp();
    }

    @Override
    public SnapshotWriter writer() {
        this.checkWriter();
        return new SnapshotWriter(this.buffer.reset().slice(), this, this.store.serializer());
    }

    @Override
    protected void closeWriter(SnapshotWriter writer) {
        this.buffer.skip(writer.buffer.position()).mark();
        super.closeWriter(writer);
    }

    @Override
    public synchronized SnapshotReader reader() {
        return this.openReader(new SnapshotReader(this.buffer.reset().slice(), this, this.store.serializer()), this.descriptor);
    }

    @Override
    public Snapshot complete() {
        this.descriptor.lock();
        this.buffer.flip().position(64L).mark();
        return super.complete();
    }

    @Override
    public void close() {
        this.buffer.close();
    }

    public String toString() {
        return String.format("%s[index=%d]", this.getClass().getSimpleName(), this.descriptor.index());
    }
}

