/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.state;

import io.atomix.copycat.server.StateMachineContext;
import io.atomix.copycat.server.state.ConnectionManager;
import io.atomix.copycat.server.state.ServerClock;
import io.atomix.copycat.server.state.ServerSessionContext;
import io.atomix.copycat.server.state.ServerSessionManager;
import java.time.Clock;
import java.time.Instant;

class ServerStateMachineContext
implements StateMachineContext {
    private final ServerClock clock = new ServerClock();
    private final ConnectionManager connections;
    private final ServerSessionManager sessions;
    private Type type;
    private long index;

    public ServerStateMachineContext(ConnectionManager connections, ServerSessionManager sessions) {
        this.connections = connections;
        this.sessions = sessions;
    }

    void update(long index, Instant instant, Type type) {
        this.index = index;
        this.type = type;
        this.clock.set(instant);
    }

    void commit() {
        long index = this.index;
        for (ServerSessionContext session : this.sessions.sessions.values()) {
            session.commit(index);
        }
    }

    Type type() {
        return this.type;
    }

    @Override
    public long index() {
        return this.index;
    }

    @Override
    public Clock clock() {
        return this.clock;
    }

    @Override
    public ServerSessionManager sessions() {
        return this.sessions;
    }

    ConnectionManager connections() {
        return this.connections;
    }

    public String toString() {
        return String.format("%s[index=%d, time=%s]", this.getClass().getSimpleName(), this.index, this.clock);
    }

    static enum Type {
        COMMAND,
        QUERY;

    }
}

