/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.protocol;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.protocol.AbstractRequest;
import java.util.Objects;
import java.util.UUID;

public class RegisterRequest
extends AbstractRequest {
    private UUID client;

    public static Builder builder() {
        return new Builder(new RegisterRequest());
    }

    public static Builder builder(RegisterRequest request) {
        return new Builder(request);
    }

    public UUID client() {
        return this.client;
    }

    @Override
    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        super.writeObject(buffer, serializer);
        buffer.writeString(this.client.toString());
    }

    @Override
    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        super.readObject(buffer, serializer);
        this.client = UUID.fromString(buffer.readString());
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.client);
    }

    public boolean equals(Object object) {
        if (object instanceof RegisterRequest) {
            RegisterRequest request = (RegisterRequest)object;
            return request.client.equals(this.client);
        }
        return false;
    }

    public String toString() {
        return String.format("%s[client=%s]", this.getClass().getSimpleName(), this.client);
    }

    public static class Builder
    extends AbstractRequest.Builder<Builder, RegisterRequest> {
        protected Builder(RegisterRequest request) {
            super(request);
        }

        public Builder withClient(UUID client) {
            ((RegisterRequest)this.request).client = (UUID)Assert.notNull((Object)client, (String)"client");
            return this;
        }

        @Override
        public RegisterRequest build() {
            super.build();
            Assert.stateNot((((RegisterRequest)this.request).client == null ? 1 : 0) != 0, (String)"client cannot be null", (Object[])new Object[0]);
            return (RegisterRequest)this.request;
        }
    }
}

