/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.client;

import io.atomix.copycat.client.ConnectionStrategy;
import java.time.Duration;

public enum ConnectionStrategies implements ConnectionStrategy
{
    ONCE{

        @Override
        public void attemptFailed(ConnectionStrategy.Attempt attempt) {
            attempt.fail();
        }
    }
    ,
    EXPONENTIAL_BACKOFF{

        @Override
        public void attemptFailed(ConnectionStrategy.Attempt attempt) {
            attempt.retry(Duration.ofSeconds(Math.min(Math.round(Math.pow(2.0, attempt.attempt())), 60L)));
        }
    }
    ,
    FIBONACCI_BACKOFF{
        private final int[] FIBONACCI = new int[]{1, 1, 2, 3, 5, 8, 13};

        @Override
        public void attemptFailed(ConnectionStrategy.Attempt attempt) {
            attempt.retry(Duration.ofSeconds(this.FIBONACCI[Math.min(attempt.attempt() - 1, this.FIBONACCI.length - 1)]));
        }
    };

}

