/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.serializer;

import io.atomix.catalyst.buffer.Buffer;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.serializer.SerializerRegistry;
import io.atomix.catalyst.serializer.TypeSerializer;
import io.atomix.catalyst.serializer.collection.ArrayListSerializer;
import io.atomix.catalyst.serializer.collection.HashMapSerializer;
import io.atomix.catalyst.serializer.collection.HashSetSerializer;
import io.atomix.catalyst.serializer.collection.MapEntrySerializer;
import io.atomix.catalyst.serializer.util.BigDecimalSerializer;
import io.atomix.catalyst.serializer.util.BigIntegerSerializer;
import io.atomix.catalyst.serializer.util.BufferSerializer;
import io.atomix.catalyst.serializer.util.CalendarSerializer;
import io.atomix.catalyst.serializer.util.CatalystSerializableSerializer;
import io.atomix.catalyst.serializer.util.DateSerializer;
import io.atomix.catalyst.serializer.util.ExternalizableSerializer;
import io.atomix.catalyst.serializer.util.JavaSerializableSerializer;
import io.atomix.catalyst.serializer.util.PropertiesSerializer;
import io.atomix.catalyst.serializer.util.TimeZoneSerializer;
import java.io.Externalizable;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;

public class JdkTypeResolver
implements SerializableTypeResolver {
    private static final Map<Class<?>, Class<? extends TypeSerializer<?>>> SERIALIZERS = new LinkedHashMap(){
        {
            this.put(BigInteger.class, BigIntegerSerializer.class);
            this.put(BigDecimal.class, BigDecimalSerializer.class);
            this.put(Date.class, DateSerializer.class);
            this.put(HashMap.class, HashMapSerializer.class);
            this.put(HashSet.class, HashSetSerializer.class);
            this.put(ArrayList.class, ArrayListSerializer.class);
        }
    };
    private static final Map<Class<?>, Class<? extends TypeSerializer<?>>> ABSTRACT_SERIALIZERS = new LinkedHashMap(){
        {
            this.put(Buffer.class, BufferSerializer.class);
            this.put(Calendar.class, CalendarSerializer.class);
            this.put(TimeZone.class, TimeZoneSerializer.class);
            this.put(Map.Entry.class, MapEntrySerializer.class);
            this.put(Properties.class, PropertiesSerializer.class);
        }
    };
    private static final Map<Class<?>, Class<? extends TypeSerializer<?>>> DEFAULT_SERIALIZERS = new LinkedHashMap(){
        {
            this.put(Serializable.class, JavaSerializableSerializer.class);
            this.put(Externalizable.class, ExternalizableSerializer.class);
            this.put(CatalystSerializable.class, CatalystSerializableSerializer.class);
        }
    };

    @Override
    public void resolve(SerializerRegistry registry) {
        int i = 176;
        for (Map.Entry<Class<?>, Class<TypeSerializer<?>>> entry : SERIALIZERS.entrySet()) {
            registry.register(entry.getKey(), i++, entry.getValue());
        }
        i = 190;
        for (Map.Entry<Class<?>, Class<TypeSerializer<?>>> entry : ABSTRACT_SERIALIZERS.entrySet()) {
            registry.registerAbstract(entry.getKey(), i++, entry.getValue());
        }
        for (Map.Entry<Class<?>, Class<TypeSerializer<?>>> entry : DEFAULT_SERIALIZERS.entrySet()) {
            registry.registerDefault(entry.getKey(), entry.getValue());
        }
    }
}

