/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.transport.local;

import io.atomix.catalyst.concurrent.ComposableFuture;
import io.atomix.catalyst.concurrent.Futures;
import io.atomix.catalyst.concurrent.ThreadContext;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.transport.Client;
import io.atomix.catalyst.transport.Connection;
import io.atomix.catalyst.transport.local.LocalConnection;
import io.atomix.catalyst.transport.local.LocalServer;
import io.atomix.catalyst.transport.local.LocalServerRegistry;
import io.atomix.catalyst.util.Assert;
import java.net.ConnectException;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;

public class LocalClient
implements Client {
    private final UUID id = UUID.randomUUID();
    private final LocalServerRegistry registry;
    private final Set<LocalConnection> connections = Collections.newSetFromMap(new ConcurrentHashMap());

    public LocalClient(LocalServerRegistry registry) {
        this.registry = (LocalServerRegistry)Assert.notNull((Object)registry, (String)"registry");
    }

    private ThreadContext getContext() {
        return ThreadContext.currentContextOrThrow();
    }

    public CompletableFuture<Connection> connect(Address address) {
        Assert.notNull((Object)address, (String)"address");
        ThreadContext context = this.getContext();
        LocalServer server = this.registry.get(address);
        if (server == null) {
            return Futures.exceptionalFutureAsync((Throwable)new ConnectException("failed to connect"), (Executor)context.executor());
        }
        LocalConnection connection = new LocalConnection(context, this.connections);
        this.connections.add(connection);
        CompletableFuture<Connection> future = new CompletableFuture<Connection>();
        server.connect(connection).whenCompleteAsync((result, error) -> {
            if (error == null) {
                future.complete(connection);
            } else {
                future.completeExceptionally((Throwable)error);
            }
        }, context.executor());
        return future;
    }

    public CompletableFuture<Void> close() {
        ComposableFuture future = new ComposableFuture();
        ThreadContext context = this.getContext();
        CompletableFuture[] futures = new CompletableFuture[this.connections.size()];
        int i = 0;
        for (LocalConnection connection : this.connections) {
            futures[i++] = connection.close();
        }
        CompletableFuture.allOf(futures).whenCompleteAsync((BiConsumer)future, context.executor());
        return future;
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equals(Object object) {
        return object instanceof LocalClient && ((LocalClient)object).id.equals(this.id);
    }
}

