/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.buffer;

import io.atomix.catalyst.buffer.Buffer;
import io.atomix.catalyst.buffer.Bytes;
import io.atomix.catalyst.buffer.ReadOnlyBuffer;
import io.atomix.catalyst.buffer.SlicedBuffer;
import io.atomix.catalyst.buffer.SwappedBuffer;
import io.atomix.catalyst.buffer.util.Memory;
import io.atomix.catalyst.util.reference.ReferenceManager;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.InvalidMarkException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractBuffer
implements Buffer {
    static final long DEFAULT_INITIAL_CAPACITY = 4096L;
    protected final Bytes bytes;
    private long offset;
    private long initialCapacity;
    private long capacity;
    private long maxCapacity;
    private long position;
    private long limit = -1L;
    private long mark = -1L;
    private final AtomicInteger references = new AtomicInteger();
    private final ReferenceManager<Buffer> referenceManager;
    private SwappedBuffer swap;

    protected AbstractBuffer(Bytes bytes, ReferenceManager<Buffer> referenceManager) {
        this(bytes, 0L, 0L, 0L, referenceManager);
    }

    protected AbstractBuffer(Bytes bytes, long offset, long initialCapacity, long maxCapacity, ReferenceManager<Buffer> referenceManager) {
        if (bytes == null) {
            throw new NullPointerException("bytes cannot be null");
        }
        if (offset < 0L) {
            throw new IndexOutOfBoundsException("offset out of bounds of the underlying byte array");
        }
        this.bytes = bytes;
        this.offset = offset;
        this.capacity = 0L;
        this.initialCapacity = initialCapacity;
        this.maxCapacity = maxCapacity;
        this.capacity(initialCapacity);
        this.referenceManager = referenceManager;
        this.references.set(1);
    }

    protected AbstractBuffer reset(long offset, long capacity, long maxCapacity) {
        this.offset = offset;
        this.capacity = 0L;
        this.initialCapacity = capacity;
        this.maxCapacity = maxCapacity;
        this.capacity(this.initialCapacity);
        this.references.set(0);
        this.rewind();
        return this;
    }

    public Buffer acquire() {
        this.references.incrementAndGet();
        return this;
    }

    public boolean release() {
        if (this.references.decrementAndGet() == 0) {
            if (this.referenceManager != null) {
                this.referenceManager.release((Object)this);
            } else {
                this.bytes.close();
            }
            return true;
        }
        return false;
    }

    public int references() {
        return this.references.get();
    }

    @Override
    public Bytes bytes() {
        return this.bytes;
    }

    @Override
    public ByteOrder order() {
        return this.bytes.order();
    }

    @Override
    public Buffer order(ByteOrder order) {
        if (order == null) {
            throw new NullPointerException("order cannot be null");
        }
        if (order == this.order()) {
            return this;
        }
        if (this.swap != null) {
            return this.swap;
        }
        this.swap = new SwappedBuffer(this, this.offset, this.capacity, this.maxCapacity, this.referenceManager);
        return this.swap;
    }

    @Override
    public boolean isDirect() {
        return this.bytes.isDirect();
    }

    @Override
    public boolean isFile() {
        return this.bytes.isFile();
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public Buffer asReadOnlyBuffer() {
        return new ReadOnlyBuffer(this, this.referenceManager).reset(this.offset, this.capacity, this.maxCapacity).position(this.position).limit(this.limit);
    }

    @Override
    public Buffer compact() {
        this.compact(this.offset(this.position), this.offset, (this.limit != -1L ? this.limit : this.capacity) - this.offset(this.position));
        return this.clear();
    }

    protected abstract void compact(long var1, long var3, long var5);

    @Override
    public Buffer slice() {
        long maxCapacity = this.maxCapacity - this.position;
        long capacity = Math.min(Math.min(this.initialCapacity, maxCapacity), this.bytes.size() - this.offset(this.position));
        if (this.limit != -1L) {
            capacity = maxCapacity = this.limit - this.position;
        }
        return new SlicedBuffer(this, this.bytes, this.offset(this.position), capacity, maxCapacity);
    }

    @Override
    public Buffer slice(long length) {
        this.checkSlice(this.position, length);
        return new SlicedBuffer(this, this.bytes, this.offset(this.position), length, length);
    }

    @Override
    public Buffer slice(long offset, long length) {
        this.checkSlice(offset, length);
        return new SlicedBuffer(this, this.bytes, this.offset(offset), length, length);
    }

    @Override
    public long offset() {
        return this.offset;
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    @Override
    public Buffer capacity(long capacity) {
        if (capacity > this.maxCapacity) {
            throw new IllegalArgumentException("capacity cannot be greater than maximum capacity");
        }
        if (capacity < this.capacity) {
            throw new IllegalArgumentException("capacity cannot be decreased");
        }
        if (capacity != this.capacity) {
            if (this.offset(capacity) > this.bytes.size()) {
                this.bytes.resize(Memory.Util.toPow2(this.offset(capacity)));
            }
            this.capacity = capacity;
        }
        return this;
    }

    @Override
    public long maxCapacity() {
        return this.maxCapacity;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public Buffer position(long position) {
        if (this.limit != -1L && position > this.limit) {
            throw new IllegalArgumentException("position cannot be greater than limit");
        }
        if (this.limit == -1L && position > this.maxCapacity) {
            throw new IllegalArgumentException("position cannot be greater than capacity");
        }
        if (position > this.capacity) {
            this.capacity(Math.min(this.maxCapacity, Memory.Util.toPow2(position)));
        }
        this.position = position;
        return this;
    }

    private long offset(long offset) {
        return this.offset + offset;
    }

    @Override
    public long limit() {
        return this.limit;
    }

    @Override
    public Buffer limit(long limit) {
        if (limit > this.maxCapacity) {
            throw new IllegalArgumentException("limit cannot be greater than buffer capacity");
        }
        if (limit < -1L) {
            throw new IllegalArgumentException("limit cannot be negative");
        }
        if (limit != -1L && this.offset(limit) > this.bytes.size()) {
            this.bytes.resize(this.offset(limit));
        }
        this.limit = limit;
        return this;
    }

    @Override
    public long remaining() {
        return (this.limit == -1L ? this.maxCapacity : this.limit) - this.position;
    }

    @Override
    public boolean hasRemaining() {
        return this.remaining() > 0L;
    }

    @Override
    public Buffer flip() {
        this.limit = this.position;
        this.position = 0L;
        this.mark = -1L;
        return this;
    }

    @Override
    public Buffer mark() {
        this.mark = this.position;
        return this;
    }

    @Override
    public Buffer rewind() {
        this.position = 0L;
        this.mark = -1L;
        return this;
    }

    @Override
    public Buffer reset() {
        if (this.mark == -1L) {
            throw new InvalidMarkException();
        }
        this.position = this.mark;
        return this;
    }

    @Override
    public Buffer skip(long length) {
        if (length > this.remaining()) {
            throw new IndexOutOfBoundsException("length cannot be greater than remaining bytes in the buffer");
        }
        this.position += length;
        return this;
    }

    @Override
    public Buffer clear() {
        this.position = 0L;
        this.limit = -1L;
        this.mark = -1L;
        return this;
    }

    protected void checkOffset(long offset) {
        if (this.offset(offset) < this.offset) {
            throw new IndexOutOfBoundsException();
        }
        if (this.limit == -1L ? offset > this.maxCapacity : offset > this.limit) {
            throw new IndexOutOfBoundsException();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected long checkSlice(long offset, long length) {
        this.checkOffset(offset);
        if (this.limit == -1L) {
            if (offset + length <= this.capacity) return this.offset(offset);
            if (this.capacity >= this.maxCapacity) throw new BufferUnderflowException();
            this.capacity(this.calculateCapacity(offset + length));
            return this.offset(offset);
        } else {
            if (offset + length <= this.limit) return this.offset(offset);
            throw new BufferUnderflowException();
        }
    }

    protected long checkRead(long length) {
        this.checkRead(this.position, length);
        long previousPosition = this.position;
        this.position = previousPosition + length;
        return this.offset(previousPosition);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected long checkRead(long offset, long length) {
        this.checkOffset(offset);
        if (this.limit == -1L) {
            if (offset + length <= this.capacity) return this.offset(offset);
            if (this.capacity >= this.maxCapacity) throw new BufferUnderflowException();
            if (this.offset + offset + length <= this.bytes.size()) {
                this.capacity = this.bytes.size() - this.offset;
                return this.offset(offset);
            } else {
                this.capacity(this.calculateCapacity(offset + length));
            }
            return this.offset(offset);
        } else {
            if (offset + length <= this.limit) return this.offset(offset);
            throw new BufferUnderflowException();
        }
    }

    protected long checkWrite(long length) {
        this.checkWrite(this.position, length);
        long previousPosition = this.position;
        this.position = previousPosition + length;
        return this.offset(previousPosition);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected long checkWrite(long offset, long length) {
        this.checkOffset(offset);
        if (this.limit == -1L) {
            if (offset + length <= this.capacity) return this.offset(offset);
            if (this.capacity >= this.maxCapacity) throw new BufferOverflowException();
            this.capacity(this.calculateCapacity(offset + length));
            return this.offset(offset);
        } else {
            if (offset + length <= this.limit) return this.offset(offset);
            throw new BufferOverflowException();
        }
    }

    private long calculateCapacity(long minimumCapacity) {
        long newCapacity;
        for (newCapacity = Math.min(Math.max(this.capacity, 2L), minimumCapacity); newCapacity < Math.min(minimumCapacity, this.maxCapacity); newCapacity <<= 1) {
        }
        return Math.min(newCapacity, this.maxCapacity);
    }

    @Override
    public Buffer zero() {
        this.bytes.zero(this.offset);
        return this;
    }

    @Override
    public Buffer zero(long offset) {
        this.checkOffset(offset);
        this.bytes.zero(this.offset(offset));
        return this;
    }

    @Override
    public Buffer zero(long offset, long length) {
        this.checkOffset(offset);
        this.bytes.zero(this.offset(offset), length);
        return this;
    }

    @Override
    public Buffer read(Buffer buffer) {
        long length = Math.min(buffer.remaining(), this.remaining());
        this.read(buffer.bytes(), buffer.offset() + buffer.position(), length);
        buffer.position(buffer.position() + length);
        return this;
    }

    @Override
    public Buffer read(Bytes bytes) {
        this.bytes.read(this.checkRead(bytes.size()), bytes, 0L, bytes.size());
        return this;
    }

    @Override
    public Buffer read(Bytes bytes, long offset, long length) {
        this.bytes.read(this.checkRead(length), bytes, offset, length);
        return this;
    }

    @Override
    public Buffer read(long srcOffset, Bytes bytes, long dstOffset, long length) {
        this.bytes.read(this.checkRead(srcOffset, length), bytes, dstOffset, length);
        return this;
    }

    @Override
    public Buffer read(byte[] bytes) {
        this.bytes.read(this.checkRead(bytes.length), bytes, 0L, (long)bytes.length);
        return this;
    }

    @Override
    public Buffer read(byte[] bytes, long offset, long length) {
        this.bytes.read(this.checkRead(length), bytes, offset, length);
        return this;
    }

    @Override
    public Buffer read(long srcOffset, byte[] bytes, long dstOffset, long length) {
        this.bytes.read(this.checkRead(srcOffset, length), bytes, dstOffset, length);
        return this;
    }

    @Override
    public int readByte() {
        return this.bytes.readByte(this.checkRead(1L));
    }

    @Override
    public int readByte(long offset) {
        return this.bytes.readByte(this.checkRead(offset, 1L));
    }

    @Override
    public int readUnsignedByte() {
        return this.bytes.readUnsignedByte(this.checkRead(1L));
    }

    @Override
    public int readUnsignedByte(long offset) {
        return this.bytes.readUnsignedByte(this.checkRead(offset, 1L));
    }

    @Override
    public char readChar() {
        return this.bytes.readChar(this.checkRead(2L));
    }

    @Override
    public char readChar(long offset) {
        return this.bytes.readChar(this.checkRead(offset, 2L));
    }

    @Override
    public short readShort() {
        return this.bytes.readShort(this.checkRead(2L));
    }

    @Override
    public short readShort(long offset) {
        return this.bytes.readShort(this.checkRead(offset, 2L));
    }

    @Override
    public int readUnsignedShort() {
        return this.bytes.readUnsignedShort(this.checkRead(2L));
    }

    @Override
    public int readUnsignedShort(long offset) {
        return this.bytes.readUnsignedShort(this.checkRead(offset, 2L));
    }

    @Override
    public int readMedium() {
        return this.bytes.readMedium(this.checkRead(3L));
    }

    @Override
    public int readMedium(long offset) {
        return this.bytes.readMedium(this.checkRead(offset, 3L));
    }

    @Override
    public int readUnsignedMedium() {
        return this.bytes.readUnsignedMedium(this.checkRead(3L));
    }

    @Override
    public int readUnsignedMedium(long offset) {
        return this.bytes.readUnsignedMedium(this.checkRead(offset, 3L));
    }

    @Override
    public int readInt() {
        return this.bytes.readInt(this.checkRead(4L));
    }

    @Override
    public int readInt(long offset) {
        return this.bytes.readInt(this.checkRead(offset, 4L));
    }

    @Override
    public long readUnsignedInt() {
        return this.bytes.readUnsignedInt(this.checkRead(4L));
    }

    @Override
    public long readUnsignedInt(long offset) {
        return this.bytes.readUnsignedInt(this.checkRead(offset, 4L));
    }

    @Override
    public long readLong() {
        return this.bytes.readLong(this.checkRead(8L));
    }

    @Override
    public long readLong(long offset) {
        return this.bytes.readLong(this.checkRead(offset, 8L));
    }

    @Override
    public float readFloat() {
        return this.bytes.readFloat(this.checkRead(4L));
    }

    @Override
    public float readFloat(long offset) {
        return this.bytes.readFloat(this.checkRead(offset, 4L));
    }

    @Override
    public double readDouble() {
        return this.bytes.readDouble(this.checkRead(8L));
    }

    @Override
    public double readDouble(long offset) {
        return this.bytes.readDouble(this.checkRead(offset, 8L));
    }

    @Override
    public boolean readBoolean() {
        return this.bytes.readBoolean(this.checkRead(1L));
    }

    @Override
    public boolean readBoolean(long offset) {
        return this.bytes.readBoolean(this.checkRead(offset, 1L));
    }

    @Override
    public String readString(Charset charset) {
        if (this.readBoolean(this.position)) {
            byte[] bytes = new byte[this.readUnsignedShort(this.position + 1L)];
            this.read(this.position + 1L + 2L, bytes, 0L, (long)bytes.length);
            this.position += (long)(3 + bytes.length);
            return new String(bytes, charset);
        }
        ++this.position;
        return null;
    }

    @Override
    public String readString(long offset, Charset charset) {
        if (this.readBoolean(offset)) {
            byte[] bytes = new byte[this.readUnsignedShort(offset + 1L)];
            this.read(offset + 1L + 2L, bytes, 0L, (long)bytes.length);
            return new String(bytes, charset);
        }
        return null;
    }

    @Override
    public String readString() {
        return this.readString(Charset.defaultCharset());
    }

    @Override
    public String readString(long offset) {
        return this.readString(offset, Charset.defaultCharset());
    }

    @Override
    public String readUTF8() {
        return this.readString(StandardCharsets.UTF_8);
    }

    @Override
    public String readUTF8(long offset) {
        return this.readString(offset, StandardCharsets.UTF_8);
    }

    @Override
    public Buffer write(Buffer buffer) {
        long length = Math.min(buffer.remaining(), this.remaining());
        this.write(buffer.bytes(), buffer.offset() + buffer.position(), length);
        buffer.position(buffer.position() + length);
        return this;
    }

    @Override
    public Buffer write(Bytes bytes) {
        this.bytes.write(this.checkWrite(bytes.size()), bytes, 0L, bytes.size());
        return this;
    }

    @Override
    public Buffer write(Bytes bytes, long offset, long length) {
        this.bytes.write(this.checkWrite(length), bytes, offset, length);
        return this;
    }

    @Override
    public Buffer write(long offset, Bytes bytes, long srcOffset, long length) {
        this.bytes.write(this.checkWrite(offset, length), bytes, srcOffset, length);
        return this;
    }

    @Override
    public Buffer write(byte[] bytes) {
        this.bytes.write(this.checkWrite(bytes.length), bytes, 0L, (long)bytes.length);
        return this;
    }

    @Override
    public Buffer write(byte[] bytes, long offset, long length) {
        this.bytes.write(this.checkWrite(length), bytes, offset, length);
        return this;
    }

    @Override
    public Buffer write(long offset, byte[] bytes, long srcOffset, long length) {
        this.bytes.write(this.checkWrite(offset, length), bytes, srcOffset, length);
        return this;
    }

    @Override
    public Buffer writeByte(int b) {
        this.bytes.writeByte(this.checkWrite(1L), b);
        return this;
    }

    @Override
    public Buffer writeByte(long offset, int b) {
        this.bytes.writeByte(this.checkWrite(offset, 1L), b);
        return this;
    }

    @Override
    public Buffer writeUnsignedByte(int b) {
        this.bytes.writeUnsignedByte(this.checkWrite(1L), b);
        return this;
    }

    @Override
    public Buffer writeUnsignedByte(long offset, int b) {
        this.bytes.writeUnsignedByte(this.checkWrite(offset, 1L), b);
        return this;
    }

    @Override
    public Buffer writeChar(char c) {
        this.bytes.writeChar(this.checkWrite(2L), c);
        return this;
    }

    @Override
    public Buffer writeChar(long offset, char c) {
        this.bytes.writeChar(this.checkWrite(offset, 2L), c);
        return this;
    }

    @Override
    public Buffer writeShort(short s) {
        this.bytes.writeShort(this.checkWrite(2L), s);
        return this;
    }

    @Override
    public Buffer writeShort(long offset, short s) {
        this.bytes.writeShort(this.checkWrite(offset, 2L), s);
        return this;
    }

    @Override
    public Buffer writeUnsignedShort(int s) {
        this.bytes.writeUnsignedShort(this.checkWrite(2L), s);
        return this;
    }

    @Override
    public Buffer writeUnsignedShort(long offset, int s) {
        this.bytes.writeUnsignedShort(this.checkWrite(offset, 2L), s);
        return this;
    }

    @Override
    public Buffer writeMedium(int m) {
        this.bytes.writeMedium(this.checkWrite(3L), m);
        return this;
    }

    @Override
    public Buffer writeMedium(long offset, int m) {
        this.bytes.writeMedium(this.checkWrite(offset, 3L), m);
        return this;
    }

    @Override
    public Buffer writeUnsignedMedium(int m) {
        this.bytes.writeUnsignedMedium(this.checkWrite(3L), m);
        return this;
    }

    @Override
    public Buffer writeUnsignedMedium(long offset, int m) {
        this.bytes.writeUnsignedMedium(this.checkWrite(offset, 3L), m);
        return this;
    }

    @Override
    public Buffer writeInt(int i) {
        this.bytes.writeInt(this.checkWrite(4L), i);
        return this;
    }

    @Override
    public Buffer writeInt(long offset, int i) {
        this.bytes.writeInt(this.checkWrite(offset, 4L), i);
        return this;
    }

    @Override
    public Buffer writeUnsignedInt(long i) {
        this.bytes.writeUnsignedInt(this.checkWrite(4L), i);
        return this;
    }

    @Override
    public Buffer writeUnsignedInt(long offset, long i) {
        this.bytes.writeUnsignedInt(this.checkWrite(offset, 4L), i);
        return this;
    }

    @Override
    public Buffer writeLong(long l) {
        this.bytes.writeLong(this.checkWrite(8L), l);
        return this;
    }

    @Override
    public Buffer writeLong(long offset, long l) {
        this.bytes.writeLong(this.checkWrite(offset, 8L), l);
        return this;
    }

    @Override
    public Buffer writeFloat(float f) {
        this.bytes.writeFloat(this.checkWrite(4L), f);
        return this;
    }

    @Override
    public Buffer writeFloat(long offset, float f) {
        this.bytes.writeFloat(this.checkWrite(offset, 4L), f);
        return this;
    }

    @Override
    public Buffer writeDouble(double d) {
        this.bytes.writeDouble(this.checkWrite(8L), d);
        return this;
    }

    @Override
    public Buffer writeDouble(long offset, double d) {
        this.bytes.writeDouble(this.checkWrite(offset, 8L), d);
        return this;
    }

    @Override
    public Buffer writeBoolean(boolean b) {
        this.bytes.writeBoolean(this.checkWrite(1L), b);
        return this;
    }

    @Override
    public Buffer writeBoolean(long offset, boolean b) {
        this.bytes.writeBoolean(this.checkWrite(offset, 1L), b);
        return this;
    }

    @Override
    public Buffer writeString(String s, Charset charset) {
        if (s == null) {
            return this.writeBoolean(this.checkWrite(1L), Boolean.FALSE);
        }
        byte[] bytes = s.getBytes(charset);
        this.checkWrite(this.position, 3 + bytes.length);
        this.writeBoolean(Boolean.TRUE).writeUnsignedShort(bytes.length).write(bytes, 0L, (long)bytes.length);
        return this;
    }

    @Override
    public Buffer writeString(long offset, String s, Charset charset) {
        if (s == null) {
            return this.writeBoolean(this.checkWrite(offset, 1L), Boolean.FALSE);
        }
        byte[] bytes = s.getBytes(charset);
        this.checkWrite(offset, 3 + bytes.length);
        this.writeBoolean(offset, Boolean.TRUE).writeUnsignedShort(offset + 1L, bytes.length).write(offset + 1L + 2L, bytes, 0L, (long)bytes.length);
        return this;
    }

    @Override
    public Buffer writeString(String s) {
        return this.writeString(s, Charset.defaultCharset());
    }

    @Override
    public Buffer writeString(long offset, String s) {
        return this.writeString(offset, s, Charset.defaultCharset());
    }

    @Override
    public Buffer writeUTF8(String s) {
        return this.writeString(s, StandardCharsets.UTF_8);
    }

    @Override
    public Buffer writeUTF8(long offset, String s) {
        return this.writeString(offset, s, StandardCharsets.UTF_8);
    }

    @Override
    public Buffer flush() {
        this.bytes.flush();
        return this;
    }

    @Override
    public void close() {
        this.references.set(0);
        if (this.referenceManager != null) {
            this.referenceManager.release((Object)this);
        } else {
            this.bytes.close();
        }
    }
}

