/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.buffer.util;

import io.atomix.catalyst.buffer.HeapBytes;

public class BitArray
implements AutoCloseable {
    private final HeapBytes bytes;
    private long size;
    private long count;

    public static BitArray allocate(long bits) {
        if (!(bits > 0L & (bits & bits - 1L) == 0L)) {
            throw new IllegalArgumentException("size must be a power of 2");
        }
        return new BitArray(HeapBytes.allocate(Math.max(bits / 8L + 8L, 8L)), bits);
    }

    private BitArray(HeapBytes bytes, long size) {
        this(bytes, 0L, size);
    }

    private BitArray(HeapBytes bytes, long count, long size) {
        this.bytes = bytes;
        this.size = size;
        this.count = count;
    }

    private long offset(long index) {
        return index / 64L * 8L;
    }

    private long position(long index) {
        return index % 64L;
    }

    public boolean set(long index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        if (!this.get(index)) {
            this.bytes.writeLong(this.offset(index), this.bytes.readLong(this.offset(index)) | 1L << (int)this.position(index));
            ++this.count;
            return true;
        }
        return false;
    }

    public boolean get(long index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return (this.bytes.readLong(this.offset(index)) & 1L << (int)this.position(index)) != 0L;
    }

    public long size() {
        return this.size;
    }

    public long count() {
        return this.count;
    }

    public BitArray resize(long size) {
        this.bytes.resize(Math.max(size / 8L + 8L, 8L));
        this.size = size;
        return this;
    }

    public BitArray copy() {
        return new BitArray(this.bytes.copy(), this.count, this.size);
    }

    @Override
    public void close() {
        this.bytes.close();
    }

    public String toString() {
        return String.format("%s[size=%d]", this.getClass().getSimpleName(), this.size);
    }
}

