/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.resource;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.resource.Resource;
import io.atomix.resource.ResourceFactory;
import io.atomix.resource.ResourceTypeInfo;

public class ResourceType
implements CatalystSerializable {
    private int id;
    private Class<? extends ResourceFactory<?>> factory;

    public ResourceType() {
    }

    public ResourceType(Class<? extends Resource> type) {
        ResourceTypeInfo info = type.getAnnotation(ResourceTypeInfo.class);
        if (info == null) {
            throw new IllegalArgumentException("resource type not annotated");
        }
        this.id = info.id();
        this.factory = info.factory();
    }

    public ResourceType(int id, Class<? extends ResourceFactory<?>> factory) {
        this.id = id;
        this.factory = (Class)Assert.notNull(factory, (String)"factory");
    }

    public int id() {
        return this.id;
    }

    public Class<? extends ResourceFactory<?>> factory() {
        return this.factory;
    }

    public void writeObject(BufferOutput<?> buffer, Serializer serializer) {
        buffer.writeInt(this.id);
        serializer.writeObject(this.factory, buffer);
    }

    public void readObject(BufferInput<?> buffer, Serializer serializer) {
        this.id = buffer.readInt();
        this.factory = (Class)serializer.readObject(buffer);
    }

    public int hashCode() {
        int hashCode = 23;
        hashCode = 37 * hashCode + this.id;
        return hashCode;
    }

    public boolean equals(Object object) {
        if (object instanceof ResourceType) {
            ResourceType resourceType = (ResourceType)object;
            return resourceType.id == this.id;
        }
        return false;
    }

    public String toString() {
        return String.format("%s[id=%d, factory=%s]", this.getClass().getSimpleName(), this.id, this.factory);
    }
}

