/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.resource;

import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.server.Commit;
import io.atomix.copycat.server.StateMachine;
import io.atomix.copycat.server.StateMachineExecutor;
import io.atomix.copycat.server.session.ServerSession;
import io.atomix.copycat.server.session.SessionListener;
import io.atomix.resource.ResourceStateMachineExecutor;
import io.atomix.resource.internal.ResourceCommand;
import io.atomix.resource.internal.ResourceQuery;
import java.util.Properties;

public abstract class ResourceStateMachine
extends StateMachine
implements SessionListener {
    protected final Properties config;

    protected ResourceStateMachine(Properties config) {
        this.config = (Properties)Assert.notNull((Object)config, (String)"config");
    }

    public final void init(StateMachineExecutor executor) {
        executor.serializer().register(ResourceCommand.class, -50);
        executor.serializer().register(ResourceQuery.class, -51);
        executor.serializer().register(ResourceQuery.Config.class, -52);
        executor.serializer().register(ResourceCommand.Delete.class, -53);
        executor.context().sessions().addListener((SessionListener)this);
        ResourceStateMachineExecutor wrappedExecutor = new ResourceStateMachineExecutor(executor);
        wrappedExecutor.register(ResourceQuery.Config.class, this::config);
        wrappedExecutor.register(ResourceCommand.Delete.class, this::delete);
        super.init((StateMachineExecutor)wrappedExecutor);
    }

    public void register(ServerSession session) {
    }

    public void unregister(ServerSession session) {
    }

    public void expire(ServerSession session) {
    }

    public void close(ServerSession session) {
    }

    private Properties config(Commit<ResourceQuery.Config> commit) {
        try {
            Properties properties = this.config;
            return properties;
        }
        finally {
            commit.close();
        }
    }

    private void delete(Commit<ResourceCommand.Delete> commit) {
        try {
            this.delete();
        }
        finally {
            commit.close();
        }
    }

    public void delete() {
    }
}

