/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.group.messaging.internal;

import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.Command;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.group.internal.GroupCommands;
import io.atomix.group.messaging.internal.AbstractMessageProducer;
import io.atomix.group.messaging.internal.MessageProducerRegistry;
import java.util.concurrent.CompletableFuture;

public class MessageProducerService {
    private final MessageProducerRegistry registry = new MessageProducerRegistry();
    private final CopycatClient client;

    public MessageProducerService(CopycatClient client) {
        this.client = (CopycatClient)Assert.notNull((Object)client, (String)"client");
    }

    MessageProducerRegistry registry() {
        return this.registry;
    }

    public CompletableFuture<Void> send(GroupCommands.Message message) {
        return this.client.submit((Command)message);
    }

    public void onAck(GroupCommands.Ack ack) {
        AbstractMessageProducer producer = this.registry.get(ack.producer());
        if (producer != null) {
            producer.onAck(ack);
        }
    }
}

