/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.group.messaging.internal;

import io.atomix.group.messaging.internal.AbstractMessageConsumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

final class MessageConsumerRegistry {
    private final Map<String, List<AbstractMessageConsumer>> consumers = new HashMap<String, List<AbstractMessageConsumer>>();
    private final Map<String, Iterator<AbstractMessageConsumer>> iterators = new HashMap<String, Iterator<AbstractMessageConsumer>>();

    MessageConsumerRegistry() {
    }

    void register(String name, AbstractMessageConsumer consumer) {
        List consumers = this.consumers.computeIfAbsent(name, n -> new ArrayList());
        consumers.add(consumer);
        this.iterators.computeIfAbsent(name, n -> new MessageConsumerIterator(consumers));
    }

    public AbstractMessageConsumer get(String name) {
        Iterator<AbstractMessageConsumer> iterator = this.iterators.get(name);
        return iterator != null && iterator.hasNext() ? iterator.next() : null;
    }

    void close(String name, AbstractMessageConsumer consumer) {
        List<AbstractMessageConsumer> consumers = this.consumers.get(name);
        if (consumers != null) {
            consumers.remove(consumer);
            if (consumers.isEmpty()) {
                this.consumers.remove(name);
                this.iterators.remove(name);
            }
        }
    }

    private static class MessageConsumerIterator
    implements Iterator<AbstractMessageConsumer> {
        private final List<AbstractMessageConsumer> consumers;
        private int index;

        private MessageConsumerIterator(List<AbstractMessageConsumer> consumers) {
            this.consumers = consumers;
        }

        @Override
        public boolean hasNext() {
            return !this.consumers.isEmpty();
        }

        @Override
        public AbstractMessageConsumer next() {
            int index = this.index++;
            if (this.index == this.consumers.size()) {
                this.index = 0;
            }
            return this.consumers.get(index);
        }
    }
}

