/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.group.internal;

import io.atomix.group.internal.GroupCommands;
import io.atomix.group.internal.MemberState;
import io.atomix.group.internal.MembersState;
import io.atomix.group.internal.MessageState;
import java.util.HashMap;
import java.util.Map;

final class QueueState
implements AutoCloseable {
    private final Map<Long, MessageState> messages = new HashMap<Long, MessageState>();
    private final MembersState members;

    QueueState(MembersState members) {
        this.members = members;
    }

    public void submit(MessageState message) {
        if (message.send(this.members)) {
            this.messages.put(message.index(), message);
        } else {
            message.close();
        }
    }

    public void reply(GroupCommands.Reply reply) {
        MemberState member;
        MessageState message = this.messages.get(reply.id());
        if (message != null && (member = this.members.get(reply.member())) != null) {
            member.reply(message, reply);
        }
    }

    public void close(MessageState message) {
        this.messages.remove(message.index());
        message.close();
    }

    @Override
    public void close() {
        this.messages.values().forEach(MessageState::close);
    }
}

