/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.group.messaging.internal;

import io.atomix.catalyst.concurrent.Listener;
import io.atomix.group.messaging.Message;
import io.atomix.group.messaging.MessageConsumer;
import io.atomix.group.messaging.internal.AbstractMessageService;
import io.atomix.group.messaging.internal.GroupMessage;
import java.util.function.Consumer;

public abstract class AbstractMessageConsumer<T>
implements MessageConsumer<T> {
    private final String name;
    private final AbstractMessageService service;
    private volatile Listener<Message<T>> listener;

    protected AbstractMessageConsumer(String name, MessageConsumer.Options options, AbstractMessageService service) {
        this.name = name;
        this.service = service;
        service.consumerService().registry().register(name, this);
    }

    String name() {
        return this.name;
    }

    @Override
    public Listener<Message<T>> onMessage(Consumer<Message<T>> callback) {
        this.listener = new ConsumerListener(callback);
        return this.listener;
    }

    void onMessage(GroupMessage<T> message) {
        Listener<Message<T>> listener = this.listener;
        if (listener != null) {
            listener.accept(message.setConsumerService(this.service.consumerService()));
        } else {
            message.fail();
        }
    }

    @Override
    public void close() {
        this.service.consumerService().registry().close(this.name, this);
    }

    private class ConsumerListener<T>
    implements Listener<Message<T>> {
        private final Consumer<Message<T>> callback;

        private ConsumerListener(Consumer<Message<T>> callback) {
            this.callback = callback;
        }

        public void accept(Message<T> message) {
            this.callback.accept(message);
        }

        public void close() {
            if (AbstractMessageConsumer.this.listener == this) {
                AbstractMessageConsumer.this.close();
            }
        }
    }
}

