/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.group.internal;

import io.atomix.catalyst.concurrent.Listener;
import io.atomix.catalyst.concurrent.Listeners;
import io.atomix.copycat.Command;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.group.DistributedGroup;
import io.atomix.group.GroupMember;
import io.atomix.group.LocalMember;
import io.atomix.group.election.Election;
import io.atomix.group.election.internal.GroupElection;
import io.atomix.group.internal.AbstractGroupMember;
import io.atomix.group.internal.GroupCommands;
import io.atomix.group.internal.GroupMemberInfo;
import io.atomix.group.internal.LocalGroupMember;
import io.atomix.group.internal.RemoteGroupMember;
import io.atomix.group.messaging.MessageClient;
import io.atomix.group.messaging.internal.GroupMessage;
import io.atomix.group.messaging.internal.GroupMessageClient;
import io.atomix.group.messaging.internal.MessageConsumerService;
import io.atomix.group.messaging.internal.MessageProducerService;
import io.atomix.resource.AbstractResource;
import io.atomix.resource.Resource;
import io.atomix.resource.ResourceType;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;

public class MembershipGroup
extends AbstractResource<DistributedGroup>
implements DistributedGroup {
    private final Listeners<GroupMember> joinListeners = new Listeners();
    private final Listeners<GroupMember> leaveListeners = new Listeners();
    private final GroupElection election = new GroupElection(this);
    private final GroupMessageClient messages;
    private final Map<String, AbstractGroupMember> members = new ConcurrentHashMap<String, AbstractGroupMember>();
    private final MessageProducerService producerService = new MessageProducerService(this.client);
    private final MessageConsumerService consumerService = new MessageConsumerService(this.client);

    public MembershipGroup(CopycatClient client, Properties options) {
        super(client, new ResourceType(DistributedGroup.class), options);
        this.messages = new GroupMessageClient(this.producerService);
    }

    public DistributedGroup.Config config() {
        return new DistributedGroup.Config((Properties)this.config);
    }

    public Resource.Options options() {
        return this.options;
    }

    @Override
    public Election election() {
        return this.election;
    }

    @Override
    public MessageClient messaging() {
        return this.messages;
    }

    @Override
    public GroupMember member(String memberId) {
        return this.members.get(memberId);
    }

    @Override
    public Collection<GroupMember> members() {
        return this.members.values();
    }

    @Override
    public CompletableFuture<LocalMember> join() {
        return this.join(UUID.randomUUID().toString(), false, null);
    }

    @Override
    public CompletableFuture<LocalMember> join(String memberId) {
        return this.join(memberId, true, null);
    }

    @Override
    public CompletableFuture<LocalMember> join(Object metadata) {
        return this.join(UUID.randomUUID().toString(), false, metadata);
    }

    @Override
    public CompletableFuture<LocalMember> join(String memberId, Object metadata) {
        return this.join(memberId == null ? UUID.randomUUID().toString() : memberId, memberId != null, metadata);
    }

    private CompletableFuture<LocalMember> join(String memberId, boolean persistent, Object metadata) {
        return this.client.submit((Command)new GroupCommands.Join(memberId, persistent, metadata)).thenApply(info -> {
            AbstractGroupMember member = this.members.get(info.memberId());
            if (member == null || !(member instanceof LocalGroupMember)) {
                member = new LocalGroupMember((GroupMemberInfo)info, this, this.producerService, this.consumerService);
                this.members.put(info.memberId(), member);
            }
            return (LocalGroupMember)member;
        });
    }

    @Override
    public Listener<GroupMember> onJoin(Consumer<GroupMember> listener) {
        return this.joinListeners.add(listener);
    }

    @Override
    public CompletableFuture<Void> remove(String memberId) {
        return this.client.submit((Command)new GroupCommands.Leave(memberId)).thenRun(() -> this.members.remove(memberId));
    }

    @Override
    public Listener<GroupMember> onLeave(Consumer<GroupMember> listener) {
        return this.leaveListeners.add(listener);
    }

    public CompletableFuture<DistributedGroup> open() {
        return ((CompletableFuture)((CompletableFuture)this.client.connect().thenApply(result -> {
            this.client.onEvent("join", this::onJoinEvent);
            this.client.onEvent("leave", this::onLeaveEvent);
            this.client.onEvent("message", this::onMessageEvent);
            this.client.onEvent("ack", this::onAckEvent);
            this.client.onEvent("term", this::onTermEvent);
            this.client.onEvent("elect", this::onElectEvent);
            return result;
        })).thenCompose(v -> this.sync())).thenApply(v -> this);
    }

    private CompletableFuture<Void> sync() {
        return this.client.submit((Command)new GroupCommands.Listen()).thenAccept(members -> {
            for (GroupMemberInfo info : members) {
                AbstractGroupMember member = this.members.get(info.memberId());
                if (member != null) continue;
                member = new RemoteGroupMember(info, this, this.producerService);
                this.members.put(member.id(), member);
            }
        });
    }

    private void onJoinEvent(GroupMemberInfo info) {
        AbstractGroupMember member = this.members.get(info.memberId());
        if (member == null) {
            member = new RemoteGroupMember(info, this, this.producerService);
            this.members.put(info.memberId(), member);
            this.joinListeners.accept((Object)member);
        } else if (member instanceof LocalGroupMember) {
            this.joinListeners.accept((Object)member);
        }
    }

    private void onLeaveEvent(String memberId) {
        GroupMember member = this.members.remove(memberId);
        if (member != null) {
            this.leaveListeners.accept((Object)member);
        }
    }

    private void onMessageEvent(GroupMessage message) {
        this.consumerService.onMessage(message);
    }

    private void onAckEvent(GroupCommands.Ack ack) {
        this.producerService.onAck(ack);
    }

    private void onTermEvent(long term) {
        this.election.onTerm(term);
    }

    private void onElectEvent(String memberId) {
        AbstractGroupMember member = this.members.get(memberId);
        if (member != null) {
            this.election.onElection(member);
        }
    }
}

