/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.group.internal;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.CatalystSerializable;
import io.atomix.catalyst.serializer.SerializableTypeResolver;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.serializer.SerializerRegistry;
import io.atomix.copycat.Command;
import io.atomix.copycat.Operation;
import io.atomix.copycat.Query;
import io.atomix.group.internal.GroupMemberInfo;
import io.atomix.group.messaging.MessageProducer;
import io.atomix.group.messaging.internal.GroupMessage;
import java.util.Set;

public final class GroupCommands {
    private GroupCommands() {
    }

    public static class TypeResolver
    implements SerializableTypeResolver {
        public void resolve(SerializerRegistry registry) {
            registry.register(Join.class, -130);
            registry.register(Leave.class, -131);
            registry.register(Listen.class, -132);
            registry.register(Message.class, -137);
            registry.register(Reply.class, -138);
            registry.register(Ack.class, -139);
            registry.register(GroupMessage.class, -140);
            registry.register(GroupMemberInfo.class, -158);
        }
    }

    public static class Ack
    extends MemberCommand<Void> {
        private int producer;
        private String queue;
        private long id;
        private boolean succeeded;
        private Object message;

        public Ack() {
        }

        public Ack(String member, int producer, String queue, long id, boolean succeeded, Object message) {
            super(member);
            this.producer = producer;
            this.queue = queue;
            this.id = id;
            this.succeeded = succeeded;
            this.message = message;
        }

        public int producer() {
            return this.producer;
        }

        public String queue() {
            return this.queue;
        }

        public long id() {
            return this.id;
        }

        public boolean succeeded() {
            return this.succeeded;
        }

        public Object message() {
            return this.message;
        }

        @Override
        public void writeObject(BufferOutput buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            buffer.writeUnsignedShort(this.producer);
            buffer.writeString(this.queue);
            buffer.writeLong(this.id);
            buffer.writeBoolean(this.succeeded);
            serializer.writeObject(this.message, buffer);
        }

        @Override
        public void readObject(BufferInput buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.producer = buffer.readUnsignedShort();
            this.queue = buffer.readString();
            this.id = buffer.readLong();
            this.succeeded = buffer.readBoolean();
            this.message = serializer.readObject(buffer);
        }
    }

    public static class Reply
    extends MemberCommand<Void> {
        private String queue;
        private long id;
        private boolean succeeded;
        private Object message;

        public Reply() {
        }

        public Reply(String member, String queue, long id, boolean succeeded, Object message) {
            super(member);
            this.queue = queue;
            this.id = id;
            this.succeeded = succeeded;
            this.message = message;
        }

        public String queue() {
            return this.queue;
        }

        public long id() {
            return this.id;
        }

        public boolean succeeded() {
            return this.succeeded;
        }

        public Object message() {
            return this.message;
        }

        @Override
        public void writeObject(BufferOutput buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            buffer.writeString(this.queue);
            buffer.writeLong(this.id);
            buffer.writeBoolean(this.succeeded);
            serializer.writeObject(this.message, buffer);
        }

        @Override
        public void readObject(BufferInput buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.queue = buffer.readString();
            this.id = buffer.readLong();
            this.succeeded = buffer.readBoolean();
            this.message = serializer.readObject(buffer);
        }
    }

    public static class Message
    extends MemberCommand<Void> {
        private int producer;
        private long id;
        private String queue;
        private Object message;
        private MessageProducer.Delivery delivery;
        private MessageProducer.Execution execution;

        public Message() {
        }

        public Message(String member, int producer, String queue, long id, Object message, MessageProducer.Delivery delivery, MessageProducer.Execution execution) {
            super(member);
            this.producer = producer;
            this.queue = queue;
            this.id = id;
            this.message = message;
            this.delivery = delivery;
            this.execution = execution;
        }

        public int producer() {
            return this.producer;
        }

        public String queue() {
            return this.queue;
        }

        public long id() {
            return this.id;
        }

        public Object message() {
            return this.message;
        }

        public MessageProducer.Delivery delivery() {
            return this.delivery;
        }

        public MessageProducer.Execution execution() {
            return this.execution;
        }

        @Override
        public void writeObject(BufferOutput buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            buffer.writeUnsignedShort(this.producer);
            buffer.writeString(this.queue);
            buffer.writeLong(this.id);
            buffer.writeByte(this.delivery.ordinal());
            buffer.writeByte(this.execution.ordinal());
            serializer.writeObject(this.message, buffer);
        }

        @Override
        public void readObject(BufferInput buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.producer = buffer.readUnsignedShort();
            this.queue = buffer.readString();
            this.id = buffer.readLong();
            this.delivery = MessageProducer.Delivery.values()[buffer.readByte()];
            this.execution = MessageProducer.Execution.values()[buffer.readByte()];
            this.message = serializer.readObject(buffer);
        }
    }

    public static abstract class PropertyCommand<T>
    extends MemberCommand<T> {
        private String property;

        protected PropertyCommand() {
        }

        protected PropertyCommand(String member, String property) {
            super(member);
            this.property = property;
        }

        public String property() {
            return this.property;
        }

        @Override
        public void writeObject(BufferOutput buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            buffer.writeString(this.property);
        }

        @Override
        public void readObject(BufferInput buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.property = buffer.readString();
        }
    }

    public static class Listen
    extends MemberCommand<Set<GroupMemberInfo>> {
        public Listen() {
        }

        public Listen(String member) {
            super(member);
        }

        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.QUORUM;
        }
    }

    public static class Leave
    extends MemberCommand<Void> {
        public Leave() {
        }

        public Leave(String member) {
            super(member);
        }

        @Override
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.SEQUENTIAL;
        }
    }

    public static class Join
    extends MemberCommand<GroupMemberInfo> {
        private boolean persist;
        private Object metadata;

        public Join() {
        }

        public Join(String member, boolean persist, Object metadata) {
            super(member);
            this.persist = persist;
            this.metadata = metadata;
        }

        public boolean persist() {
            return this.persist;
        }

        public Object metadata() {
            return this.metadata;
        }

        @Override
        public void writeObject(BufferOutput buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            buffer.writeBoolean(this.persist);
            serializer.writeObject(this.metadata, buffer);
        }

        @Override
        public void readObject(BufferInput buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.persist = buffer.readBoolean();
            this.metadata = serializer.readObject(buffer);
        }
    }

    public static abstract class MemberQuery<V>
    extends MemberOperation<V>
    implements Query<V> {
        public MemberQuery(String member) {
            super(member);
        }

        public MemberQuery() {
        }
    }

    public static abstract class MemberCommand<V>
    extends MemberOperation<V>
    implements Command<V> {
        public MemberCommand() {
        }

        public MemberCommand(String member) {
            super(member);
        }

        public Command.CompactionMode compaction() {
            return Command.CompactionMode.QUORUM;
        }
    }

    public static abstract class GroupCommand<V>
    extends GroupOperation<V>
    implements Command<V> {
        public Command.CompactionMode compaction() {
            return Command.CompactionMode.QUORUM;
        }
    }

    public static abstract class MemberOperation<T>
    extends GroupOperation<T> {
        private String member;

        protected MemberOperation() {
        }

        protected MemberOperation(String member) {
            this.member = member;
        }

        public String member() {
            return this.member;
        }

        @Override
        public void writeObject(BufferOutput buffer, Serializer serializer) {
            super.writeObject(buffer, serializer);
            buffer.writeString(this.member);
        }

        @Override
        public void readObject(BufferInput buffer, Serializer serializer) {
            super.readObject(buffer, serializer);
            this.member = buffer.readString();
        }
    }

    public static abstract class GroupOperation<V>
    implements Operation<V>,
    CatalystSerializable {
        public void writeObject(BufferOutput<?> bufferOutput, Serializer serializer) {
        }

        public void readObject(BufferInput<?> bufferInput, Serializer serializer) {
        }
    }
}

