/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.variables;

import io.atomix.copycat.client.CopycatClient;
import io.atomix.resource.AbstractResource;
import io.atomix.resource.ReadConsistency;
import io.atomix.variables.internal.ValueCommands;
import java.time.Duration;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;

public abstract class AbstractDistributedValue<T extends AbstractDistributedValue<T, U>, U>
extends AbstractResource<T> {
    protected AbstractDistributedValue(CopycatClient client, Properties options) {
        super(client, options);
    }

    public CompletableFuture<U> get() {
        return this.client.submit(new ValueCommands.Get());
    }

    public CompletableFuture<U> get(ReadConsistency consistency) {
        return this.client.submit(new ValueCommands.Get(consistency.level()));
    }

    public CompletableFuture<Void> set(U value) {
        return this.client.submit(new ValueCommands.Set<U>(value));
    }

    public CompletableFuture<Void> set(U value, Duration ttl) {
        return this.client.submit(new ValueCommands.Set<U>(value, ttl.toMillis()));
    }

    public CompletableFuture<U> getAndSet(U value) {
        return this.client.submit(new ValueCommands.GetAndSet<U>(value));
    }

    public CompletableFuture<U> getAndSet(U value, Duration ttl) {
        return this.client.submit(new ValueCommands.GetAndSet<U>(value, ttl.toMillis()));
    }

    public CompletableFuture<Boolean> compareAndSet(U expect, U update) {
        return this.client.submit(new ValueCommands.CompareAndSet<U>(expect, update));
    }

    public CompletableFuture<Boolean> compareAndSet(U expect, U update, Duration ttl) {
        return this.client.submit(new ValueCommands.CompareAndSet<U>(expect, update, ttl.toMillis()));
    }
}

