/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.snapshot;

import io.atomix.catalyst.buffer.Buffer;
import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.Bytes;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.server.storage.snapshot.Snapshot;

public class SnapshotReader
implements BufferInput<SnapshotReader> {
    private final Buffer buffer;
    private final Snapshot snapshot;
    private final Serializer serializer;

    SnapshotReader(Buffer buffer, Snapshot snapshot, Serializer serializer) {
        this.buffer = Assert.notNull(buffer, "buffer");
        this.snapshot = Assert.notNull(snapshot, "snapshot");
        this.serializer = Assert.notNull(serializer, "serializer");
    }

    @Override
    public long remaining() {
        return this.buffer.remaining();
    }

    @Override
    public boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    @Override
    public SnapshotReader skip(long bytes) {
        this.buffer.skip(bytes);
        return this;
    }

    public <T> T readObject() {
        return this.serializer.readObject(this.buffer);
    }

    @Override
    public SnapshotReader read(Bytes bytes) {
        this.buffer.read(bytes);
        return this;
    }

    @Override
    public SnapshotReader read(byte[] bytes) {
        this.buffer.read(bytes);
        return this;
    }

    @Override
    public SnapshotReader read(Bytes bytes, long offset, long length) {
        this.buffer.read(bytes, offset, length);
        return this;
    }

    @Override
    public SnapshotReader read(byte[] bytes, long offset, long length) {
        this.buffer.read(bytes, offset, length);
        return this;
    }

    @Override
    public SnapshotReader read(Buffer buffer) {
        this.buffer.read(buffer);
        return this;
    }

    @Override
    public int readByte() {
        return this.buffer.readByte();
    }

    @Override
    public int readUnsignedByte() {
        return this.buffer.readUnsignedByte();
    }

    @Override
    public char readChar() {
        return this.buffer.readChar();
    }

    @Override
    public short readShort() {
        return this.buffer.readShort();
    }

    @Override
    public int readUnsignedShort() {
        return this.buffer.readUnsignedShort();
    }

    @Override
    public int readMedium() {
        return this.buffer.readMedium();
    }

    @Override
    public int readUnsignedMedium() {
        return this.buffer.readUnsignedMedium();
    }

    @Override
    public int readInt() {
        return this.buffer.readInt();
    }

    @Override
    public long readUnsignedInt() {
        return this.buffer.readUnsignedInt();
    }

    @Override
    public long readLong() {
        return this.buffer.readLong();
    }

    @Override
    public float readFloat() {
        return this.buffer.readFloat();
    }

    @Override
    public double readDouble() {
        return this.buffer.readDouble();
    }

    @Override
    public boolean readBoolean() {
        return this.buffer.readBoolean();
    }

    @Override
    public String readString() {
        return this.buffer.readString();
    }

    @Override
    public String readUTF8() {
        return this.buffer.readUTF8();
    }

    @Override
    public void close() {
        this.buffer.close();
        this.snapshot.closeReader(this);
    }
}

