/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.snapshot;

import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.server.storage.snapshot.SnapshotDescriptor;
import io.atomix.copycat.server.storage.snapshot.SnapshotReader;
import io.atomix.copycat.server.storage.snapshot.SnapshotStore;
import io.atomix.copycat.server.storage.snapshot.SnapshotWriter;

public abstract class Snapshot
implements AutoCloseable {
    private final SnapshotStore store;
    private SnapshotWriter writer;

    protected Snapshot(SnapshotStore store) {
        this.store = Assert.notNull(store, "store");
    }

    public abstract long index();

    public abstract long timestamp();

    public abstract SnapshotWriter writer();

    protected void checkWriter() {
        Assert.state(this.writer == null, "cannot create multiple writers for the same snapshot", new Object[0]);
    }

    protected SnapshotWriter openWriter(SnapshotWriter writer, SnapshotDescriptor descriptor) {
        this.checkWriter();
        Assert.stateNot(descriptor.locked(), "cannot write to locked snapshot descriptor", new Object[0]);
        this.writer = Assert.notNull(writer, "writer");
        return writer;
    }

    protected void closeWriter(SnapshotWriter writer) {
        this.writer = null;
    }

    public abstract SnapshotReader reader();

    protected SnapshotReader openReader(SnapshotReader reader, SnapshotDescriptor descriptor) {
        Assert.state(descriptor.locked(), "cannot read from unlocked snapshot descriptor", new Object[0]);
        return reader;
    }

    protected void closeReader(SnapshotReader reader) {
        reader = null;
    }

    public Snapshot complete() {
        this.store.completeSnapshot(this);
        return this;
    }

    @Override
    public void close() {
    }

    public void delete() {
    }
}

