/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage.entry;

import io.atomix.catalyst.buffer.BufferInput;
import io.atomix.catalyst.buffer.BufferOutput;
import io.atomix.catalyst.serializer.Serializer;
import io.atomix.catalyst.transport.Address;
import io.atomix.catalyst.util.Assert;
import io.atomix.catalyst.util.reference.ReferenceManager;
import io.atomix.copycat.server.storage.entry.Entry;
import io.atomix.copycat.server.storage.entry.TimestampedEntry;
import java.util.UUID;

public class ConnectEntry
extends TimestampedEntry<ConnectEntry> {
    private UUID client;
    private Address address;

    public ConnectEntry() {
    }

    public ConnectEntry(ReferenceManager<Entry<?>> referenceManager) {
        super(referenceManager);
    }

    public UUID getClient() {
        return this.client;
    }

    public ConnectEntry setClient(UUID client) {
        this.client = Assert.notNull(client, "client");
        return this;
    }

    public Address getAddress() {
        return this.address;
    }

    public ConnectEntry setAddress(Address address) {
        this.address = Assert.notNull(address, "address");
        return this;
    }

    @Override
    public void writeObject(BufferOutput buffer, Serializer serializer) {
        super.writeObject(buffer, serializer);
        buffer.writeString(this.client.toString());
        serializer.writeObject(this.address, buffer);
    }

    @Override
    public void readObject(BufferInput buffer, Serializer serializer) {
        super.readObject(buffer, serializer);
        this.client = UUID.fromString(buffer.readString());
        this.address = (Address)serializer.readObject(buffer);
    }

    @Override
    public String toString() {
        return String.format("%s[index=%d, term=%d, client=%s, address=%s, timestamp=%d]", this.getClass().getSimpleName(), this.getIndex(), this.getTerm(), this.getClient(), this.getAddress(), this.getTimestamp());
    }
}

