/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.storage;

import io.atomix.catalyst.concurrent.ThreadContext;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.server.storage.Log;
import io.atomix.copycat.server.storage.SegmentFile;
import io.atomix.copycat.server.storage.StorageCleaner;
import io.atomix.copycat.server.storage.StorageLevel;
import io.atomix.copycat.server.storage.snapshot.SnapshotFile;
import io.atomix.copycat.server.storage.snapshot.SnapshotStore;
import io.atomix.copycat.server.storage.system.MetaStore;
import java.io.File;
import java.time.Duration;

public class Storage {
    private static final String DEFAULT_DIRECTORY = System.getProperty("user.dir");
    private static final int DEFAULT_MAX_SEGMENT_SIZE = 0x2000000;
    private static final int DEFAULT_MAX_ENTRIES_PER_SEGMENT = 0x100000;
    private static final int DEFAULT_ENTRY_BUFFER_SIZE = 1024;
    private static final boolean DEFAULT_FLUSH_ON_COMMIT = false;
    private static final boolean DEFAULT_RETAIN_STALE_SNAPSHOTS = false;
    private static final int DEFAULT_COMPACTION_THREADS = Runtime.getRuntime().availableProcessors() / 2;
    private static final Duration DEFAULT_MINOR_COMPACTION_INTERVAL = Duration.ofMinutes(1L);
    private static final Duration DEFAULT_MAJOR_COMPACTION_INTERVAL = Duration.ofHours(1L);
    private static final double DEFAULT_COMPACTION_THRESHOLD = 0.5;
    private StorageLevel storageLevel = StorageLevel.DISK;
    private File directory = new File(DEFAULT_DIRECTORY);
    private int maxSegmentSize = 0x2000000;
    private int maxEntriesPerSegment = 0x100000;
    private int entryBufferSize = 1024;
    private boolean flushOnCommit = false;
    private boolean retainStaleSnapshots = false;
    private int compactionThreads = DEFAULT_COMPACTION_THREADS;
    private Duration minorCompactionInterval = DEFAULT_MINOR_COMPACTION_INTERVAL;
    private Duration majorCompactionInterval = DEFAULT_MAJOR_COMPACTION_INTERVAL;
    private double compactionThreshold = 0.5;

    public static Builder builder() {
        return new Builder();
    }

    public Storage() {
    }

    public Storage(StorageLevel storageLevel) {
        this.storageLevel = Assert.notNull(storageLevel, "storageLevel");
    }

    public Storage(String directory) {
        this(new File(Assert.notNull(directory, "directory")));
    }

    public Storage(File directory) {
        this(directory, StorageLevel.DISK);
    }

    public Storage(String directory, StorageLevel storageLevel) {
        this(new File(Assert.notNull(directory, "directory")), storageLevel);
    }

    public Storage(File directory, StorageLevel storageLevel) {
        this.directory = Assert.notNull(directory, "directory");
        this.storageLevel = Assert.notNull(storageLevel, "storageLevel");
    }

    public File directory() {
        return this.directory;
    }

    public StorageLevel level() {
        return this.storageLevel;
    }

    public int maxSegmentSize() {
        return this.maxSegmentSize;
    }

    public int maxEntriesPerSegment() {
        return this.maxEntriesPerSegment;
    }

    public int entryBufferSize() {
        return this.entryBufferSize;
    }

    public boolean flushOnCommit() {
        return this.flushOnCommit;
    }

    public boolean retainStaleSnapshots() {
        return this.retainStaleSnapshots;
    }

    public int compactionThreads() {
        return this.compactionThreads;
    }

    public Duration minorCompactionInterval() {
        return this.minorCompactionInterval;
    }

    public Duration majorCompactionInterval() {
        return this.majorCompactionInterval;
    }

    public double compactionThreshold() {
        return this.compactionThreshold;
    }

    public MetaStore openMetaStore(String name) {
        return new MetaStore(name, this, ThreadContext.currentContextOrThrow().serializer().clone());
    }

    public void deleteMetaStore(String name) {
        StorageCleaner cleaner = new StorageCleaner(this);
        cleaner.cleanFiles(f -> f.getName().equals(String.format("%s.meta", name)));
    }

    public SnapshotStore openSnapshotStore(String name) {
        return new SnapshotStore(name, this, ThreadContext.currentContextOrThrow().serializer().clone());
    }

    public void deleteSnapshotStore(String name) {
        StorageCleaner cleaner = new StorageCleaner(this);
        cleaner.cleanFiles(f -> SnapshotFile.isSnapshotFile(name, f));
    }

    public Log openLog(String name) {
        return new Log(name, this, ThreadContext.currentContextOrThrow().serializer().clone());
    }

    public void deleteLog(String name) {
        StorageCleaner cleaner = new StorageCleaner(this);
        cleaner.cleanFiles(f -> SegmentFile.isSegmentFile(name, f));
    }

    public String toString() {
        return String.format("%s[directory=%s]", this.getClass().getSimpleName(), this.directory);
    }

    public static class Builder
    implements io.atomix.catalyst.util.Builder<Storage> {
        private final Storage storage = new Storage();

        private Builder() {
        }

        public Builder withStorageLevel(StorageLevel storageLevel) {
            this.storage.storageLevel = Assert.notNull(storageLevel, "storageLevel");
            return this;
        }

        public Builder withDirectory(String directory) {
            return this.withDirectory(new File(Assert.notNull(directory, "directory")));
        }

        public Builder withDirectory(File directory) {
            this.storage.directory = Assert.notNull(directory, "directory");
            return this;
        }

        public Builder withMaxSegmentSize(int maxSegmentSize) {
            Assert.arg(maxSegmentSize > 64, "maxSegmentSize must be greater than 64", new Object[0]);
            this.storage.maxSegmentSize = maxSegmentSize;
            return this;
        }

        public Builder withMaxEntriesPerSegment(int maxEntriesPerSegment) {
            Assert.arg(maxEntriesPerSegment > 0, "max entries per segment must be positive", new Object[0]);
            Assert.argNot(maxEntriesPerSegment > 0x100000, "max entries per segment cannot be greater than 1048576", new Object[0]);
            this.storage.maxEntriesPerSegment = maxEntriesPerSegment;
            return this;
        }

        public Builder withEntryBufferSize(int entryBufferSize) {
            this.storage.entryBufferSize = Assert.arg(entryBufferSize, entryBufferSize > 0, "entryBufferSize must be positive", new Object[0]);
            return this;
        }

        public Builder withFlushOnCommit() {
            return this.withFlushOnCommit(true);
        }

        public Builder withFlushOnCommit(boolean flushOnCommit) {
            this.storage.flushOnCommit = flushOnCommit;
            return this;
        }

        public Builder withRetainStaleSnapshots() {
            return this.withRetainStaleSnapshots(true);
        }

        public Builder withRetainStaleSnapshots(boolean retainStaleSnapshots) {
            this.storage.retainStaleSnapshots = retainStaleSnapshots;
            return this;
        }

        public Builder withCompactionThreads(int compactionThreads) {
            this.storage.compactionThreads = Assert.arg(compactionThreads, compactionThreads > 0, "compactionThreads must be positive", new Object[0]);
            return this;
        }

        public Builder withMinorCompactionInterval(Duration interval) {
            this.storage.minorCompactionInterval = Assert.notNull(interval, "interval");
            return this;
        }

        public Builder withMajorCompactionInterval(Duration interval) {
            this.storage.majorCompactionInterval = Assert.notNull(interval, "interval");
            return this;
        }

        public Builder withCompactionThreshold(double threshold) {
            this.storage.compactionThreshold = Assert.argNot(threshold, threshold <= 0.0, "threshold must be positive", new Object[0]);
            return this;
        }

        @Override
        public Storage build() {
            return this.storage;
        }
    }
}

