/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.state;

import io.atomix.catalyst.concurrent.Futures;
import io.atomix.catalyst.transport.Connection;
import io.atomix.copycat.protocol.CommandRequest;
import io.atomix.copycat.protocol.CommandResponse;
import io.atomix.copycat.protocol.ConnectRequest;
import io.atomix.copycat.protocol.ConnectResponse;
import io.atomix.copycat.protocol.KeepAliveRequest;
import io.atomix.copycat.protocol.KeepAliveResponse;
import io.atomix.copycat.protocol.PublishRequest;
import io.atomix.copycat.protocol.PublishResponse;
import io.atomix.copycat.protocol.QueryRequest;
import io.atomix.copycat.protocol.QueryResponse;
import io.atomix.copycat.protocol.RegisterRequest;
import io.atomix.copycat.protocol.RegisterResponse;
import io.atomix.copycat.protocol.Response;
import io.atomix.copycat.protocol.UnregisterRequest;
import io.atomix.copycat.protocol.UnregisterResponse;
import io.atomix.copycat.server.CopycatServer;
import io.atomix.copycat.server.protocol.AcceptRequest;
import io.atomix.copycat.server.protocol.AcceptResponse;
import io.atomix.copycat.server.protocol.AppendRequest;
import io.atomix.copycat.server.protocol.AppendResponse;
import io.atomix.copycat.server.protocol.ConfigureRequest;
import io.atomix.copycat.server.protocol.ConfigureResponse;
import io.atomix.copycat.server.protocol.InstallRequest;
import io.atomix.copycat.server.protocol.InstallResponse;
import io.atomix.copycat.server.protocol.JoinRequest;
import io.atomix.copycat.server.protocol.JoinResponse;
import io.atomix.copycat.server.protocol.LeaveRequest;
import io.atomix.copycat.server.protocol.LeaveResponse;
import io.atomix.copycat.server.protocol.PollRequest;
import io.atomix.copycat.server.protocol.PollResponse;
import io.atomix.copycat.server.protocol.ReconfigureRequest;
import io.atomix.copycat.server.protocol.ReconfigureResponse;
import io.atomix.copycat.server.protocol.VoteRequest;
import io.atomix.copycat.server.protocol.VoteResponse;
import io.atomix.copycat.server.state.AbstractState;
import io.atomix.copycat.server.state.ServerContext;
import io.atomix.copycat.server.storage.system.Configuration;
import java.util.concurrent.CompletableFuture;

class InactiveState
extends AbstractState {
    public InactiveState(ServerContext context) {
        super(context);
    }

    @Override
    public CopycatServer.State type() {
        return CopycatServer.State.INACTIVE;
    }

    @Override
    protected CompletableFuture<ConfigureResponse> configure(ConfigureRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        this.updateTermAndLeader(request.term(), request.leader());
        Configuration configuration = new Configuration(request.index(), request.term(), request.timestamp(), request.members());
        this.context.getClusterState().configure(configuration);
        if (this.context.getCommitIndex() >= this.context.getClusterState().getConfiguration().index()) {
            this.context.getClusterState().commit();
        }
        return CompletableFuture.completedFuture(this.logResponse(((ConfigureResponse.Builder)ConfigureResponse.builder().withStatus(Response.Status.OK)).build()));
    }

    @Override
    protected CompletableFuture<RegisterResponse> register(RegisterRequest request) {
        return Futures.exceptionalFuture(new IllegalStateException("inactive state"));
    }

    @Override
    protected CompletableFuture<ConnectResponse> connect(ConnectRequest request, Connection connection) {
        return Futures.exceptionalFuture(new IllegalStateException("inactive state"));
    }

    @Override
    protected CompletableFuture<AcceptResponse> accept(AcceptRequest request) {
        return Futures.exceptionalFuture(new IllegalStateException("inactive state"));
    }

    @Override
    protected CompletableFuture<KeepAliveResponse> keepAlive(KeepAliveRequest request) {
        return Futures.exceptionalFuture(new IllegalStateException("inactive state"));
    }

    @Override
    protected CompletableFuture<UnregisterResponse> unregister(UnregisterRequest request) {
        return Futures.exceptionalFuture(new IllegalStateException("inactive state"));
    }

    @Override
    protected CompletableFuture<PublishResponse> publish(PublishRequest request) {
        return Futures.exceptionalFuture(new IllegalStateException("inactive state"));
    }

    @Override
    protected CompletableFuture<InstallResponse> install(InstallRequest request) {
        return Futures.exceptionalFuture(new IllegalStateException("inactive state"));
    }

    @Override
    protected CompletableFuture<JoinResponse> join(JoinRequest request) {
        return Futures.exceptionalFuture(new IllegalStateException("inactive state"));
    }

    @Override
    protected CompletableFuture<ReconfigureResponse> reconfigure(ReconfigureRequest request) {
        return Futures.exceptionalFuture(new IllegalStateException("inactive state"));
    }

    @Override
    protected CompletableFuture<LeaveResponse> leave(LeaveRequest request) {
        return Futures.exceptionalFuture(new IllegalStateException("inactive state"));
    }

    @Override
    protected CompletableFuture<AppendResponse> append(AppendRequest request) {
        return Futures.exceptionalFuture(new IllegalStateException("inactive state"));
    }

    @Override
    protected CompletableFuture<PollResponse> poll(PollRequest request) {
        return Futures.exceptionalFuture(new IllegalStateException("inactive state"));
    }

    @Override
    protected CompletableFuture<VoteResponse> vote(VoteRequest request) {
        return Futures.exceptionalFuture(new IllegalStateException("inactive state"));
    }

    @Override
    protected CompletableFuture<CommandResponse> command(CommandRequest request) {
        return Futures.exceptionalFuture(new IllegalStateException("inactive state"));
    }

    @Override
    protected CompletableFuture<QueryResponse> query(QueryRequest request) {
        return Futures.exceptionalFuture(new IllegalStateException("inactive state"));
    }
}

