/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.server.state;

import io.atomix.copycat.protocol.Request;
import io.atomix.copycat.protocol.Response;
import io.atomix.copycat.server.CopycatServer;
import io.atomix.copycat.server.protocol.AppendRequest;
import io.atomix.copycat.server.protocol.AppendResponse;
import io.atomix.copycat.server.protocol.PollRequest;
import io.atomix.copycat.server.protocol.PollResponse;
import io.atomix.copycat.server.protocol.VoteRequest;
import io.atomix.copycat.server.protocol.VoteResponse;
import io.atomix.copycat.server.state.PassiveState;
import io.atomix.copycat.server.state.ServerContext;
import io.atomix.copycat.server.storage.entry.ConnectEntry;
import io.atomix.copycat.server.storage.entry.Entry;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;

abstract class ActiveState
extends PassiveState {
    protected ActiveState(ServerContext context) {
        super(context);
    }

    @Override
    protected CompletableFuture<AppendResponse> append(AppendRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        boolean transition = this.updateTermAndLeader(request.term(), request.leader());
        CompletableFuture<AppendResponse> future = CompletableFuture.completedFuture(this.logResponse(this.handleAppend(request)));
        if (transition) {
            this.context.transition(CopycatServer.State.FOLLOWER);
        }
        return future;
    }

    @Override
    protected AppendResponse checkPreviousEntry(AppendRequest request) {
        if (request.logIndex() != 0L && this.context.getLog().isEmpty()) {
            this.LOGGER.debug("{} - Rejected {}: Previous index ({}) is greater than the local log's last index ({})", new Object[]{this.context.getCluster().member().address(), request, request.logIndex(), this.context.getLog().lastIndex()});
            return ((AppendResponse.Builder)AppendResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withSucceeded(false).withLogIndex(this.context.getLog().lastIndex()).build();
        }
        if (request.logIndex() != 0L && this.context.getLog().lastIndex() != 0L && request.logIndex() > this.context.getLog().lastIndex()) {
            this.LOGGER.debug("{} - Rejected {}: Previous index ({}) is greater than the local log's last index ({})", new Object[]{this.context.getCluster().member().address(), request, request.logIndex(), this.context.getLog().lastIndex()});
            return ((AppendResponse.Builder)AppendResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withSucceeded(false).withLogIndex(this.context.getLog().lastIndex()).build();
        }
        long term = this.context.getLog().term(request.logIndex());
        if (term == 0L || term != request.logTerm()) {
            this.LOGGER.debug("{} - Rejected {}: Request log term does not match local log term {} for the same entry", new Object[]{this.context.getCluster().member().address(), request, term});
            return ((AppendResponse.Builder)AppendResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withSucceeded(false).withLogIndex(request.logIndex() <= this.context.getLog().lastIndex() ? request.logIndex() - 1L : this.context.getLog().lastIndex()).build();
        }
        return this.appendEntries(request);
    }

    @Override
    protected AppendResponse appendEntries(AppendRequest request) {
        if (!request.entries().isEmpty()) {
            for (Entry entry : request.entries()) {
                if (this.context.getLog().lastIndex() < entry.getIndex()) {
                    this.context.getLog().skip(entry.getIndex() - this.context.getLog().lastIndex() - 1L).append(entry);
                    this.LOGGER.debug("{} - Appended {} to log at index {}", new Object[]{this.context.getCluster().member().address(), entry, entry.getIndex()});
                } else {
                    if (this.context.getCommitIndex() >= entry.getIndex()) continue;
                    long term = this.context.getLog().term(entry.getIndex());
                    if (term != 0L) {
                        if (entry.getTerm() != term) {
                            this.LOGGER.debug("{} - Appended entry term does not match local log, removing incorrect entries", (Object)this.context.getCluster().member().address());
                            this.context.getLog().truncate(entry.getIndex() - 1L).append(entry);
                            this.LOGGER.debug("{} - Appended {} to log at index {}", new Object[]{this.context.getCluster().member().address(), entry, entry.getIndex()});
                        }
                    } else {
                        this.context.getLog().truncate(entry.getIndex() - 1L).append(entry);
                        this.LOGGER.debug("{} - Appended {} to log at index {}", new Object[]{this.context.getCluster().member().address(), entry, entry.getIndex()});
                    }
                }
                if (!(entry instanceof ConnectEntry)) continue;
                ConnectEntry connectEntry = (ConnectEntry)entry;
                this.context.getStateMachine().executor().context().sessions().registerAddress(connectEntry.getClient(), connectEntry.getAddress());
            }
        }
        this.context.setCommitIndex(request.commitIndex());
        this.context.setGlobalIndex(request.globalIndex());
        this.context.getStateMachine().applyAll(this.context.getCommitIndex());
        return ((AppendResponse.Builder)AppendResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withSucceeded(true).withLogIndex(this.context.getLog().lastIndex()).build();
    }

    @Override
    protected CompletableFuture<PollResponse> poll(PollRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        this.updateTermAndLeader(request.term(), 0);
        return CompletableFuture.completedFuture(this.logResponse(this.handlePoll(request)));
    }

    protected PollResponse handlePoll(PollRequest request) {
        if (request.term() < this.context.getTerm()) {
            this.LOGGER.debug("{} - Rejected {}: candidate's term is less than the current term", (Object)this.context.getCluster().member().address(), (Object)request);
            return ((PollResponse.Builder)PollResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withAccepted(false).build();
        }
        if (this.isLogUpToDate(request.logIndex(), request.logTerm(), request)) {
            return ((PollResponse.Builder)PollResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withAccepted(true).build();
        }
        return ((PollResponse.Builder)PollResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withAccepted(false).build();
    }

    @Override
    protected CompletableFuture<VoteResponse> vote(VoteRequest request) {
        this.context.checkThread();
        this.logRequest(request);
        boolean transition = this.updateTermAndLeader(request.term(), 0);
        CompletableFuture<VoteResponse> future = CompletableFuture.completedFuture(this.logResponse(this.handleVote(request)));
        if (transition) {
            this.context.transition(CopycatServer.State.FOLLOWER);
        }
        return future;
    }

    protected VoteResponse handleVote(VoteRequest request) {
        if (request.term() < this.context.getTerm()) {
            this.LOGGER.debug("{} - Rejected {}: candidate's term is less than the current term", (Object)this.context.getCluster().member().address(), (Object)request);
            return ((VoteResponse.Builder)VoteResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withVoted(false).build();
        }
        if (this.context.getLeader() != null) {
            this.LOGGER.debug("{} - Rejected {}: leader already exists", (Object)this.context.getCluster().member().address(), (Object)request);
            return ((VoteResponse.Builder)VoteResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withVoted(false).build();
        }
        if (!this.context.getClusterState().getRemoteMemberStates().stream().map(m -> m.getMember().id()).collect(Collectors.toSet()).contains(request.candidate())) {
            this.LOGGER.debug("{} - Rejected {}: candidate is not known to the local member", (Object)this.context.getCluster().member().address(), (Object)request);
            return ((VoteResponse.Builder)VoteResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withVoted(false).build();
        }
        if (this.context.getLastVotedFor() == 0) {
            if (this.isLogUpToDate(request.logIndex(), request.logTerm(), request)) {
                this.context.setLastVotedFor(request.candidate());
                return ((VoteResponse.Builder)VoteResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withVoted(true).build();
            }
            return ((VoteResponse.Builder)VoteResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withVoted(false).build();
        }
        if (this.context.getLastVotedFor() == request.candidate()) {
            this.LOGGER.debug("{} - Accepted {}: already voted for {}", new Object[]{this.context.getCluster().member().address(), request, this.context.getCluster().member(this.context.getLastVotedFor()).address()});
            return ((VoteResponse.Builder)VoteResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withVoted(true).build();
        }
        this.LOGGER.debug("{} - Rejected {}: already voted for {}", new Object[]{this.context.getCluster().member().address(), request, this.context.getCluster().member(this.context.getLastVotedFor()).address()});
        return ((VoteResponse.Builder)VoteResponse.builder().withStatus(Response.Status.OK)).withTerm(this.context.getTerm()).withVoted(false).build();
    }

    boolean isLogUpToDate(long lastIndex, long lastTerm, Request request) {
        if (this.context.getLog().isEmpty()) {
            this.LOGGER.debug("{} - Accepted {}: candidate's log is up-to-date", (Object)this.context.getCluster().member().address(), (Object)request);
            return true;
        }
        long localLastIndex = this.context.getLog().lastIndex();
        long localLastTerm = this.context.getLog().term(localLastIndex);
        if (lastTerm < localLastTerm) {
            this.LOGGER.debug("{} - Rejected {}: candidate's last log entry ({}) is at a lower term than the local log ({})", new Object[]{this.context.getCluster().member().address(), request, lastTerm, localLastTerm});
            return false;
        }
        if (lastTerm == localLastTerm && lastIndex < localLastIndex) {
            this.LOGGER.debug("{} - Rejected {}: candidate's last log entry ({}) is at a lower index than the local log ({})", new Object[]{this.context.getCluster().member().address(), request, lastIndex, localLastIndex});
            return false;
        }
        this.LOGGER.debug("{} - Accepted {}: candidate's log is up-to-date", (Object)this.context.getCluster().member().address(), (Object)request);
        return true;
    }
}

