/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.copycat.client.session;

import io.atomix.catalyst.concurrent.Futures;
import io.atomix.catalyst.concurrent.Listener;
import io.atomix.catalyst.concurrent.ThreadContext;
import io.atomix.catalyst.transport.Connection;
import io.atomix.catalyst.util.Assert;
import io.atomix.copycat.client.session.ClientSequencer;
import io.atomix.copycat.client.session.ClientSessionState;
import io.atomix.copycat.error.UnknownSessionException;
import io.atomix.copycat.protocol.PublishRequest;
import io.atomix.copycat.protocol.PublishResponse;
import io.atomix.copycat.protocol.Response;
import io.atomix.copycat.session.Event;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;

final class ClientSessionListener {
    private final ClientSessionState state;
    private final ThreadContext context;
    private final Map<String, Set<Consumer>> eventListeners = new ConcurrentHashMap<String, Set<Consumer>>();
    private final ClientSequencer sequencer;

    public ClientSessionListener(Connection connection, ClientSessionState state, ClientSequencer sequencer, ThreadContext context) {
        this.state = Assert.notNull(state, "state");
        this.context = Assert.notNull(context, "context");
        this.sequencer = Assert.notNull(sequencer, "sequencer");
        connection.handler(PublishRequest.class, this::handlePublish);
    }

    public Listener<Void> onEvent(String event, Runnable callback) {
        return this.onEvent(event, (T v) -> callback.run());
    }

    public <T> Listener<T> onEvent(String event, final Consumer listener) {
        final Set listeners = this.eventListeners.computeIfAbsent(event, e -> new CopyOnWriteArraySet());
        listeners.add(listener);
        return new Listener<T>(){

            @Override
            public void accept(T event) {
                listener.accept(event);
            }

            @Override
            public void close() {
                listeners.remove(listener);
            }
        };
    }

    private CompletableFuture<PublishResponse> handlePublish(PublishRequest request) {
        this.state.getLogger().debug("{} - Received {}", (Object)this.state.getSessionId(), (Object)request);
        if (request.session() != this.state.getSessionId()) {
            this.state.getLogger().debug("{} - Inconsistent session ID: {}", (Object)this.state.getSessionId(), (Object)request.session());
            return Futures.exceptionalFuture(new UnknownSessionException("incorrect session ID", new Object[0]));
        }
        if (request.eventIndex() <= this.state.getEventIndex()) {
            return CompletableFuture.completedFuture(((PublishResponse.Builder)PublishResponse.builder().withStatus(Response.Status.OK)).withIndex(this.state.getEventIndex()).build());
        }
        if (request.previousIndex() != this.state.getEventIndex()) {
            this.state.getLogger().debug("{} - Inconsistent event index: {}", (Object)this.state.getSessionId(), (Object)request.previousIndex());
            return CompletableFuture.completedFuture(((PublishResponse.Builder)PublishResponse.builder().withStatus(Response.Status.ERROR)).withIndex(this.state.getEventIndex()).build());
        }
        this.state.setEventIndex(request.eventIndex());
        this.sequencer.sequenceEvent(request, () -> {
            for (Event<?> event : request.events()) {
                Set<Consumer> listeners = this.eventListeners.get(event.name());
                if (listeners == null) continue;
                for (Consumer listener : listeners) {
                    listener.accept(event.message());
                }
            }
        });
        return CompletableFuture.completedFuture(((PublishResponse.Builder)PublishResponse.builder().withStatus(Response.Status.OK)).withIndex(request.eventIndex()).build());
    }

    public CompletableFuture<Void> close() {
        return CompletableFuture.completedFuture(null);
    }
}

