/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.collections;

import io.atomix.collections.internal.SetCommands;
import io.atomix.collections.util.DistributedSetFactory;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.resource.AbstractResource;
import io.atomix.resource.ReadConsistency;
import io.atomix.resource.ResourceTypeInfo;
import java.time.Duration;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;

@ResourceTypeInfo(id=-13, factory=DistributedSetFactory.class)
public class DistributedSet<T>
extends AbstractResource<DistributedSet<T>> {
    public DistributedSet(CopycatClient client, Properties options) {
        super(client, options);
    }

    public CompletableFuture<Boolean> add(T value) {
        return this.client.submit(new SetCommands.Add(value));
    }

    public CompletableFuture<Boolean> add(T value, Duration ttl) {
        return this.client.submit(new SetCommands.Add(value, ttl.toMillis()));
    }

    public CompletableFuture<Boolean> remove(T value) {
        return this.client.submit(new SetCommands.Remove(value));
    }

    public CompletableFuture<Boolean> contains(Object value) {
        return this.client.submit(new SetCommands.Contains(value));
    }

    public CompletableFuture<Boolean> contains(Object value, ReadConsistency consistency) {
        return this.client.submit(new SetCommands.Contains(value, consistency.level()));
    }

    public CompletableFuture<Integer> size() {
        return this.client.submit(new SetCommands.Size());
    }

    public CompletableFuture<Integer> size(ReadConsistency consistency) {
        return this.client.submit(new SetCommands.Size(consistency.level()));
    }

    public CompletableFuture<Boolean> isEmpty() {
        return this.client.submit(new SetCommands.IsEmpty());
    }

    public CompletableFuture<Boolean> isEmpty(ReadConsistency consistency) {
        return this.client.submit(new SetCommands.IsEmpty(consistency.level()));
    }

    public CompletableFuture<Void> clear() {
        return this.client.submit(new SetCommands.Clear());
    }
}

