/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.collections;

import io.atomix.collections.internal.QueueCommands;
import io.atomix.collections.util.DistributedQueueFactory;
import io.atomix.copycat.client.CopycatClient;
import io.atomix.resource.AbstractResource;
import io.atomix.resource.ReadConsistency;
import io.atomix.resource.ResourceTypeInfo;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;

@ResourceTypeInfo(id=-14, factory=DistributedQueueFactory.class)
public class DistributedQueue<T>
extends AbstractResource<DistributedQueue<T>> {
    public DistributedQueue(CopycatClient client, Properties options) {
        super(client, options);
    }

    public CompletableFuture<Boolean> add(T value) {
        return this.client.submit(new QueueCommands.Add(value));
    }

    public CompletableFuture<Boolean> offer(T value) {
        return this.client.submit(new QueueCommands.Offer(value));
    }

    public CompletableFuture<T> peek() {
        return this.client.submit(new QueueCommands.Peek()).thenApply(v -> v);
    }

    public CompletableFuture<T> poll() {
        return this.client.submit(new QueueCommands.Poll()).thenApply(v -> v);
    }

    public CompletableFuture<T> element() {
        return this.client.submit(new QueueCommands.Element()).thenApply(v -> v);
    }

    public CompletableFuture<T> remove() {
        return this.client.submit(new QueueCommands.Remove()).thenApply(v -> v);
    }

    public CompletableFuture<Boolean> remove(T value) {
        return this.client.submit(new QueueCommands.Remove(value)).thenApply(v -> (boolean)((Boolean)v));
    }

    public CompletableFuture<Boolean> contains(Object value) {
        return this.client.submit(new QueueCommands.Contains(value));
    }

    public CompletableFuture<Boolean> contains(Object value, ReadConsistency consistency) {
        return this.client.submit(new QueueCommands.Contains(value, consistency.level()));
    }

    public CompletableFuture<Integer> size() {
        return this.client.submit(new QueueCommands.Size());
    }

    public CompletableFuture<Integer> size(ReadConsistency consistency) {
        return this.client.submit(new QueueCommands.Size(consistency.level()));
    }

    public CompletableFuture<Boolean> isEmpty() {
        return this.client.submit(new QueueCommands.IsEmpty());
    }

    public CompletableFuture<Boolean> isEmpty(ReadConsistency consistency) {
        return this.client.submit(new QueueCommands.IsEmpty(consistency.level()));
    }

    public CompletableFuture<Void> clear() {
        return this.client.submit(new QueueCommands.Clear());
    }
}

