/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.buffer;

import io.atomix.catalyst.buffer.Bytes;
import io.atomix.catalyst.buffer.NativeBytes;
import io.atomix.catalyst.buffer.util.MappedMemory;
import io.atomix.catalyst.buffer.util.MappedMemoryAllocator;
import java.io.File;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.file.Files;

public class MappedBytes
extends NativeBytes {
    private final File file;

    public static MappedBytes allocate(File file, long size) {
        return MappedBytes.allocate(file, MappedMemoryAllocator.DEFAULT_MAP_MODE, size);
    }

    public static MappedBytes allocate(File file, FileChannel.MapMode mode, long size) {
        if (file == null) {
            throw new NullPointerException("file cannot be null");
        }
        if (mode == null) {
            mode = MappedMemoryAllocator.DEFAULT_MAP_MODE;
        }
        if (size > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("size for MappedBytes cannot be greater than 2147483647");
        }
        return new MappedBytes(file, MappedMemory.allocate(file, mode, size));
    }

    protected MappedBytes(File file, MappedMemory memory) {
        super(memory);
        this.file = file;
    }

    public MappedBytes copy() {
        throw new UnsupportedOperationException("copy");
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    @Override
    public Bytes flush() {
        ((MappedMemory)this.memory).flush();
        return this;
    }

    public void delete() {
        try {
            Files.delete(this.file.toPath());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

