/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.catalyst.buffer;

import io.atomix.catalyst.buffer.Buffer;
import io.atomix.catalyst.buffer.BufferPool;
import io.atomix.catalyst.buffer.HeapBuffer;
import io.atomix.catalyst.buffer.HeapBytes;
import io.atomix.catalyst.util.reference.ReferenceFactory;
import io.atomix.catalyst.util.reference.ReferenceManager;

public class HeapBufferPool
extends BufferPool {
    public HeapBufferPool() {
        super(new HeapBufferFactory());
    }

    @Override
    public void release(Buffer reference) {
        reference.rewind();
        super.release(reference);
    }

    private static class HeapBufferFactory
    implements ReferenceFactory<Buffer> {
        private HeapBufferFactory() {
        }

        @Override
        public Buffer createReference(ReferenceManager<Buffer> manager) {
            HeapBuffer buffer = new HeapBuffer(HeapBytes.allocate(1024L), manager);
            buffer.reset(0L, 1024L, Long.MAX_VALUE);
            return buffer;
        }
    }
}

