/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.csv.core;

import io.atlasmap.api.AtlasException;
import io.atlasmap.csv.core.CsvConfig;
import io.atlasmap.csv.v2.CsvField;
import io.atlasmap.spi.AtlasFieldWriter;
import io.atlasmap.spi.AtlasInternalSession;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.Document;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import io.atlasmap.v2.Fields;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;

public class CsvFieldWriter
implements AtlasFieldWriter {
    private final CsvConfig csvConfig;
    private Document document;

    public CsvFieldWriter(CsvConfig csvConfig) {
        this.csvConfig = csvConfig;
        this.document = new Document();
        this.document.setFields(new Fields());
    }

    public Document getDocument() {
        return this.document;
    }

    public void write(AtlasInternalSession session) throws AtlasException {
        Field targetField = session.head().getTargetField();
        Field sourceField = session.head().getSourceField();
        if (sourceField instanceof FieldGroup) {
            FieldGroup targetFieldGroup = AtlasModelFactory.createFieldGroupFrom((Field)targetField, (boolean)true);
            for (Field sourceSubField : ((FieldGroup)sourceField).getField()) {
                CsvField targetCsvField = (CsvField)targetField;
                CsvField targetCsvSubField = new CsvField();
                AtlasModelFactory.copyField((Field)targetField, (Field)targetCsvSubField, (boolean)false);
                targetCsvSubField.setColumn(targetCsvField.getColumn());
                targetCsvSubField.setValue(sourceSubField.getValue());
                targetFieldGroup.getField().add(targetCsvSubField);
            }
            targetField = targetFieldGroup;
            session.head().setTargetField((Field)targetFieldGroup);
        } else {
            targetField.setValue(sourceField.getValue());
        }
        this.document.getFields().getField().add(targetField);
    }

    public String toCsv() throws AtlasException {
        CSVFormat csvFormat = this.csvConfig.newCsvFormat();
        String[] headers = this.csvConfig.getParsedHeaders();
        boolean ignoreHeaderCase = Boolean.TRUE.equals(this.csvConfig.getIgnoreHeaderCase());
        if (headers != null && ignoreHeaderCase) {
            for (int j = 0; j < headers.length; ++j) {
                headers[j] = headers[j].toLowerCase();
            }
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            int i;
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)out, "UTF-8");
            CSVPrinter printer = new CSVPrinter((Appendable)writer, csvFormat);
            List fields = this.document.getFields().getField();
            if (fields.isEmpty()) {
                return "";
            }
            if (!Boolean.TRUE.equals(this.csvConfig.getSkipHeaderRecord()) && this.csvConfig.getHeaders() == null) {
                Object[] headerRecords = new String[fields.size()];
                i = 0;
                for (Field field : fields) {
                    CsvField csvField;
                    if (field instanceof FieldGroup) {
                        FieldGroup fieldGroup = (FieldGroup)field;
                        csvField = (CsvField)fieldGroup.getField().get(i);
                    } else {
                        csvField = (CsvField)field;
                    }
                    if (csvField.getColumn() != null) {
                        headerRecords[csvField.getColumn().intValue()] = csvField.getName();
                    } else {
                        headerRecords[i] = csvField.getName();
                    }
                    ++i;
                }
                printer.printRecord(headerRecords);
            }
            int recordsCount = fields.get(0) instanceof FieldGroup ? ((FieldGroup)fields.get(0)).getField().size() : 1;
            for (i = 0; i < recordsCount; ++i) {
                ArrayList<String> values = new ArrayList<String>();
                for (Field field : fields) {
                    CsvField csvField;
                    if (field instanceof FieldGroup) {
                        FieldGroup fieldGroup = (FieldGroup)field;
                        csvField = (CsvField)fieldGroup.getField().get(i);
                    } else {
                        csvField = (CsvField)field;
                    }
                    if (csvField.getColumn() != null) {
                        for (int j = values.size(); j < csvField.getColumn() + 1; ++j) {
                            values.add(null);
                        }
                        values.set(csvField.getColumn(), csvField.getValue().toString());
                        continue;
                    }
                    if (headers != null) {
                        for (int j = values.size(); j < headers.length; ++j) {
                            values.add(null);
                        }
                        int column = this.findColumn(headers, ignoreHeaderCase, csvField);
                        if (column == -1) continue;
                        values.set(column, csvField.getValue().toString());
                        continue;
                    }
                    values.add(csvField.getValue().toString());
                }
                printer.printRecord(values);
            }
            writer.flush();
            String csv = out.toString();
            return csv;
        }
        catch (IOException e) {
            throw new AtlasException((Throwable)e);
        }
    }

    private int findColumn(String[] headers, boolean ignoreHeaderCase, CsvField csvField) {
        String columnName = csvField.getName();
        if (ignoreHeaderCase) {
            columnName = csvField.getName().toLowerCase();
        }
        int column = 0;
        for (column = 0; column < headers.length; ++column) {
            if (!headers[column].equals(columnName)) continue;
            return column;
        }
        return -1;
    }
}

