/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.functions;

import io.atlasmap.core.AtlasPath;
import io.atlasmap.core.BaseFunctionFactory;
import io.atlasmap.expression.Expression;
import io.atlasmap.expression.internal.BooleanExpression;
import io.atlasmap.expression.parser.ParseException;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldGroup;
import java.util.Arrays;
import java.util.List;

public class FILTER
extends BaseFunctionFactory {
    public Expression create(List<Expression> args) throws ParseException {
        if (args.size() != 2) {
            throw new ParseException("FILTER expects 2 arguments.");
        }
        Expression parentExpression = args.get(0);
        BooleanExpression filterExpression = BooleanExpression.asBooleanExpression((Expression)args.get(1));
        return ctx -> {
            Field parent = parentExpression.evaluate(ctx);
            List<Field> collection = parent instanceof FieldGroup ? ((FieldGroup)parent).getField() : Arrays.asList(parent);
            FieldGroup filtered = AtlasModelFactory.createFieldGroupFrom((Field)parent, (boolean)true);
            int index = 0;
            for (Field f : collection) {
                if (!filterExpression.matches(subCtx -> AtlasPath.extractChildren(f, subCtx))) continue;
                this.adjustRootCollectionIndex(f, index);
                ++index;
                filtered.getField().add(f);
            }
            return filtered;
        };
    }

    private void adjustRootCollectionIndex(Field f, int index) {
        AtlasPath filteredPath = new AtlasPath(f.getPath());
        Integer collectionSegmentIndex = null;
        List<AtlasPath.SegmentContext> filteredSegments = filteredPath.getSegments(true);
        if (filteredSegments.get(0).getCollectionIndex() != null) {
            collectionSegmentIndex = 0;
        } else if (filteredSegments.get(1).getCollectionIndex() != null) {
            collectionSegmentIndex = 1;
        }
        if (collectionSegmentIndex != null) {
            if (f instanceof FieldGroup) {
                AtlasPath.setCollectionIndexRecursively((FieldGroup)f, collectionSegmentIndex, index);
            } else {
                filteredPath.setCollectionIndex(collectionSegmentIndex, index);
                f.setPath(filteredPath.getOriginalPath());
            }
        }
    }
}

