/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.validators;

import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationScope;
import io.atlasmap.validators.BaseValidatorTest;
import io.atlasmap.validators.NonNullValidator;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class NonNullValidatorTest
extends BaseValidatorTest {
    @Override
    @BeforeEach
    public void setUp() {
        super.setUp();
        this.validator = new NonNullValidator(ValidationScope.MAPPING, "Cannot be null");
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        this.validator = null;
    }

    @Test
    public void testSupports() {
        Assertions.assertTrue((boolean)this.validator.supports(String.class));
        Assertions.assertTrue((boolean)this.validator.supports(Integer.class));
        Assertions.assertTrue((boolean)this.validator.supports(Double.class));
    }

    @Test
    public void testValidate() {
        String notNull = "notNull";
        this.validator.validate((Object)notNull, this.validations, null);
        Assertions.assertFalse((boolean)this.validationHelper.hasErrors());
    }

    @Test
    public void testValidateInvalid() {
        this.validator.validate(null, this.validations, null);
        Assertions.assertTrue((boolean)this.validationHelper.hasErrors());
        Assertions.assertEquals((Integer)1, (Integer)this.validationHelper.getCount());
        Validation validation = this.validationHelper.getAllValidations().get(0);
        Assertions.assertNotNull((Object)validation);
        Assertions.assertTrue((boolean)"Cannot be null".equals(validation.getMessage()));
        Assertions.assertEquals((Object)ValidationScope.MAPPING, (Object)validation.getScope());
        Assertions.assertNull((Object)validation.getId());
        String empty = "";
        this.validationHelper.getAllValidations().clear();
        this.validator.validate((Object)empty, this.validations, "testValidateInvalid-2");
        Assertions.assertTrue((boolean)this.validationHelper.hasErrors());
        Assertions.assertEquals((Integer)1, (Integer)this.validationHelper.getCount());
        Assertions.assertEquals((Object)ValidationScope.MAPPING, (Object)((Validation)this.validationHelper.getValidation().get(0)).getScope());
        Assertions.assertEquals((Object)"testValidateInvalid-2", (Object)((Validation)this.validationHelper.getValidation().get(0)).getId());
    }
}

