/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.validators;

import io.atlasmap.core.AtlasMappingUtil;
import io.atlasmap.spi.AtlasValidator;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.DataSource;
import io.atlasmap.v2.DataSourceType;
import io.atlasmap.v2.Field;
import io.atlasmap.v2.FieldType;
import io.atlasmap.v2.LookupTable;
import io.atlasmap.v2.LookupTables;
import io.atlasmap.v2.Mapping;
import io.atlasmap.v2.MappingType;
import io.atlasmap.v2.MockField;
import io.atlasmap.v2.Validation;
import io.atlasmap.v2.Validations;
import io.atlasmap.validators.AtlasValidationTestHelper;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseValidatorTest {
    protected static Logger logger = LoggerFactory.getLogger(BaseValidatorTest.class);
    protected AtlasMappingUtil mappingUtil = new AtlasMappingUtil();
    protected AtlasValidationTestHelper validationHelper = null;
    protected List<Validation> validations = null;
    protected AtlasValidator validator = null;

    @BeforeEach
    public void setUp() {
        this.validationHelper = new AtlasValidationTestHelper();
        this.validations = this.validationHelper.getValidation();
    }

    @AfterEach
    public void tearDown() {
        this.validationHelper = null;
        this.validations = null;
    }

    protected AtlasMapping getAtlasMappingFullValid() {
        AtlasMapping mapping = AtlasModelFactory.createAtlasMapping();
        mapping.setName("thisis_a_valid.name");
        DataSource src = new DataSource();
        src.setDataSourceType(DataSourceType.SOURCE);
        src.setUri("atlas:java?2");
        DataSource tgt = new DataSource();
        tgt.setDataSourceType(DataSourceType.TARGET);
        tgt.setUri("atlas:java?3");
        mapping.getDataSource().add(src);
        mapping.getDataSource().add(tgt);
        Mapping mapFieldMapping = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.MAP);
        MockField inputField = AtlasModelFactory.createMockField();
        inputField.setFieldType(FieldType.STRING);
        inputField.setCustom("java.lang.String");
        inputField.setName("inputName");
        mapFieldMapping.getInputField().add(inputField);
        MockField outputField = AtlasModelFactory.createMockField();
        outputField.setFieldType(FieldType.STRING);
        outputField.setCustom("java.lang.String");
        outputField.setName("outputName");
        mapFieldMapping.getOutputField().add(outputField);
        Mapping separateMapping = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.SEPARATE);
        MockField sIJavaField = AtlasModelFactory.createMockField();
        sIJavaField.setFieldType(FieldType.STRING);
        sIJavaField.setCustom("java.lang.String");
        sIJavaField.setName("inputName");
        separateMapping.getInputField().add(sIJavaField);
        MockField sOJavaField = AtlasModelFactory.createMockField();
        sOJavaField.setFieldType(FieldType.STRING);
        sOJavaField.setCustom("java.lang.String");
        sOJavaField.setName("outputName");
        sOJavaField.setIndex(Integer.valueOf(0));
        separateMapping.getOutputField().add(sOJavaField);
        mapping.getMappings().getMapping().add(mapFieldMapping);
        mapping.getMappings().getMapping().add(separateMapping);
        return mapping;
    }

    protected void createMockMappedFields(AtlasMapping mapping, Mapping mapFieldMapping) {
        MockField inputField = new MockField();
        inputField.setName("input.name");
        MockField outputField = new MockField();
        outputField.setName("out.name");
        mapFieldMapping.getInputField().add(inputField);
        mapFieldMapping.getOutputField().add(outputField);
        mapping.getMappings().getMapping().add(mapFieldMapping);
    }

    protected AtlasMapping getAtlasMappingWithLookupTables(String ... names) {
        AtlasMapping mapping = this.getAtlasMappingFullValid();
        LookupTables lookupTables = new LookupTables();
        mapping.setLookupTables(lookupTables);
        for (String name : names) {
            LookupTable lookupTable = new LookupTable();
            lookupTable.setName(name);
            lookupTable.setDescription("desc_".concat(name));
            lookupTables.getLookupTable().add(lookupTable);
            Mapping lookupFieldMapping = (Mapping)AtlasModelFactory.createMapping((MappingType)MappingType.LOOKUP);
            lookupFieldMapping.setDescription("field_desc_".concat(name));
            lookupFieldMapping.setLookupTableName(name);
            Field inputField = this.createInputJavaField("inputName");
            Field outputField = this.createInputJavaField("outputName");
            lookupFieldMapping.getInputField().add(inputField);
            lookupFieldMapping.getOutputField().add(outputField);
            mapping.getMappings().getMapping().add(lookupFieldMapping);
        }
        return mapping;
    }

    protected Field createInputJavaField(String inputName) {
        MockField inputJavaField = AtlasModelFactory.createMockField();
        inputJavaField.setFieldType(FieldType.STRING);
        inputJavaField.setCustom("java.lang.String");
        inputJavaField.setName(inputName);
        return inputJavaField;
    }

    protected void debugErrors(Validations validations) {
        for (Validation validation : validations.getValidation()) {
            logger.debug(AtlasValidationTestHelper.validationToString(validation));
        }
    }
}

