/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.validators;

import io.atlasmap.v2.Validation;
import io.atlasmap.v2.ValidationScope;
import io.atlasmap.v2.ValidationStatus;
import io.atlasmap.validators.AtlasValidationTestHelper;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;

public class AtlasValidationTestHelperTest {
    private AtlasValidationTestHelper validations = null;
    private Validation error = null;
    private Validation warning = null;
    private Validation info = null;

    @BeforeEach
    public void setUp() {
        this.validations = new AtlasValidationTestHelper();
        this.error = new Validation();
        this.error.setScope(ValidationScope.ALL);
        this.error.setMessage("Error message");
        this.error.setStatus(ValidationStatus.ERROR);
        this.validations.addValidation(this.error);
        this.warning = new Validation();
        this.warning.setScope(ValidationScope.DATA_SOURCE);
        this.warning.setId("atlas:testDataSource");
        this.warning.setMessage("Warning message");
        this.warning.setStatus(ValidationStatus.WARN);
        this.validations.addValidation(this.warning);
        this.info = new Validation();
        this.info.setScope(ValidationScope.MAPPING);
        this.info.setId("0001");
        this.info.setMessage("Information message");
        this.info.setStatus(ValidationStatus.INFO);
        this.validations.addValidation(this.info);
    }

    @AfterEach
    public void tearDown() {
        this.validations = null;
        this.error = null;
        this.warning = null;
        this.info = null;
    }

    @Test
    public void testGetScope() {
        Assertions.assertEquals((Object)ValidationScope.ALL, (Object)this.error.getScope());
        Assertions.assertEquals((Object)ValidationScope.DATA_SOURCE, (Object)this.warning.getScope());
        Assertions.assertEquals((Object)ValidationScope.MAPPING, (Object)this.info.getScope());
    }

    @Test
    public void testGetRejectedValue() {
        Assertions.assertNull((Object)this.error.getId());
        Assertions.assertEquals((Object)"atlas:testDataSource", (Object)this.warning.getId());
        Assertions.assertEquals((Object)"0001", (Object)this.info.getId());
    }

    @Test
    public void testGetDefaultMessage() {
        Assertions.assertTrue((boolean)this.error.getMessage().equals("Error message"));
        Assertions.assertTrue((boolean)this.warning.getMessage().equals("Warning message"));
        Assertions.assertTrue((boolean)this.info.getMessage().equals("Information message"));
    }

    @Test
    public void testGetLevel() {
        Assertions.assertTrue((this.error.getStatus().compareTo((Enum)ValidationStatus.ERROR) == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.warning.getStatus().compareTo((Enum)ValidationStatus.WARN) == 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.info.getStatus().compareTo((Enum)ValidationStatus.INFO) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testToString() {
        Assertions.assertEquals((Object)ValidationScope.ALL, (Object)this.error.getScope());
        Assertions.assertNull((Object)this.error.getId());
        Assertions.assertEquals((Object)"Error message", (Object)this.error.getMessage());
        Assertions.assertEquals((Object)ValidationStatus.ERROR, (Object)this.error.getStatus());
        Assertions.assertEquals((Object)ValidationScope.DATA_SOURCE, (Object)this.warning.getScope());
        Assertions.assertEquals((Object)"atlas:testDataSource", (Object)this.warning.getId());
        Assertions.assertEquals((Object)"Warning message", (Object)this.warning.getMessage());
        Assertions.assertEquals((Object)ValidationStatus.WARN, (Object)this.warning.getStatus());
        Assertions.assertEquals((Object)ValidationScope.MAPPING, (Object)this.info.getScope());
        Assertions.assertEquals((Object)"0001", (Object)this.info.getId());
        Assertions.assertEquals((Object)"Information message", (Object)this.info.getMessage());
        Assertions.assertEquals((Object)ValidationStatus.INFO, (Object)this.info.getStatus());
    }

    @Test
    public void testEquals() {
        Assertions.assertFalse((boolean)this.error.equals(this.info));
    }

    @Test
    @Disabled
    public void testHashCode() {
        Assertions.assertEquals((int)1000142829, (int)this.error.hashCode());
        Assertions.assertEquals((int)this.warning.hashCode(), (int)-187767976);
        Assertions.assertEquals((int)this.info.hashCode(), (int)-1746235594);
    }
}

