/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.core.DefaultAtlasSeparateStrategy;
import io.atlasmap.spi.AtlasSeparateStrategy;
import io.atlasmap.spi.StringDelimiter;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DefaultAtlasSeparateStrategyTest {
    private AtlasSeparateStrategy separate = null;

    @BeforeEach
    public void setUp() {
        this.separate = new DefaultAtlasSeparateStrategy();
    }

    @AfterEach
    public void tearDown() {
        this.separate = null;
    }

    @Test
    public void testGetName() {
        Assertions.assertNotNull((Object)this.separate);
        Assertions.assertEquals((Object)"DefaultAtlasSeparateStrategy", (Object)this.separate.getName());
    }

    @Test
    public void testGetSetDelimiter() {
        Assertions.assertNotNull((Object)this.separate);
        Assertions.assertNotNull((Object)this.separate.getDelimiter());
        Assertions.assertEquals((Object)DefaultAtlasSeparateStrategy.DEFAULT_SEPARATE_DELIMITER, (Object)this.separate.getDelimiter());
        this.separate.setDelimiter(StringDelimiter.COLON);
        Assertions.assertEquals((Object)StringDelimiter.COLON, (Object)this.separate.getDelimiter());
        List values = this.separate.separateValue("a:b:c:d");
        Assertions.assertNotNull((Object)values);
        Assertions.assertEquals((Integer)4, (Integer)values.size());
        Assertions.assertEquals((Object)"a", values.get(0));
        Assertions.assertEquals((Object)"b", values.get(1));
        Assertions.assertEquals((Object)"c", values.get(2));
        Assertions.assertEquals((Object)"d", values.get(3));
    }

    @Test
    public void testGetSetLimit() {
        Assertions.assertNotNull((Object)this.separate);
        Assertions.assertNotNull((Object)this.separate.getDelimiter());
        Assertions.assertEquals((Integer)DefaultAtlasSeparateStrategy.DEFAULT_SEPARATE_LIMIT, (Integer)this.separate.getLimit());
        this.separate.setLimit(Integer.valueOf(2));
        List values = this.separate.separateValue("a b c d");
        Assertions.assertNotNull((Object)values);
        Assertions.assertEquals((Integer)2, (Integer)values.size());
        Assertions.assertEquals((Object)"a", values.get(0));
        Assertions.assertEquals((Object)"b c d", values.get(1));
    }

    @Test
    public void testSeparateValue() {
        Assertions.assertNotNull((Object)this.separate);
        List values = this.separate.separateValue("a b c d e f");
        Assertions.assertNotNull((Object)values);
        Assertions.assertEquals((Integer)6, (Integer)values.size());
        Assertions.assertEquals((Object)"a", values.get(0));
        Assertions.assertEquals((Object)"b", values.get(1));
        Assertions.assertEquals((Object)"c", values.get(2));
        Assertions.assertEquals((Object)"d", values.get(3));
        Assertions.assertEquals((Object)"e", values.get(4));
        Assertions.assertEquals((Object)"f", values.get(5));
    }

    @Test
    public void testSeparateValueNullDelimiter() {
        Assertions.assertNotNull((Object)this.separate);
        this.separate.setDelimiter(null);
        Assertions.assertNull((Object)this.separate.getDelimiter());
        List values = this.separate.separateValue("a b c d e f");
        Assertions.assertNotNull((Object)values);
        Assertions.assertEquals((Integer)6, (Integer)values.size());
        Assertions.assertEquals((Object)"a", values.get(0));
        Assertions.assertEquals((Object)"b", values.get(1));
        Assertions.assertEquals((Object)"c", values.get(2));
        Assertions.assertEquals((Object)"d", values.get(3));
        Assertions.assertEquals((Object)"e", values.get(4));
        Assertions.assertEquals((Object)"f", values.get(5));
    }

    @Test
    public void testSeparateValueNullLimit() {
        Assertions.assertNotNull((Object)this.separate);
        this.separate.setLimit(null);
        Assertions.assertNull((Object)this.separate.getLimit());
        List values = this.separate.separateValue("a b c d e f");
        Assertions.assertNotNull((Object)values);
        Assertions.assertEquals((Integer)6, (Integer)values.size());
        Assertions.assertEquals((Object)"a", values.get(0));
        Assertions.assertEquals((Object)"b", values.get(1));
        Assertions.assertEquals((Object)"c", values.get(2));
        Assertions.assertEquals((Object)"d", values.get(3));
        Assertions.assertEquals((Object)"e", values.get(4));
        Assertions.assertEquals((Object)"f", values.get(5));
    }

    @Test
    public void testSeparateValueNullValue() {
        Assertions.assertNotNull((Object)this.separate);
        List values = this.separate.separateValue(null);
        Assertions.assertNotNull((Object)values);
        Assertions.assertTrue((boolean)values.isEmpty());
    }

    @Test
    public void testSeparateValueEmptyValue() {
        Assertions.assertNotNull((Object)this.separate);
        List values = this.separate.separateValue("");
        Assertions.assertNotNull((Object)values);
        Assertions.assertTrue((boolean)values.isEmpty());
    }
}

