/*
 * Decompiled with CFR 0.152.
 */
package io.atlasmap.core;

import io.atlasmap.core.AtlasTestData;
import io.atlasmap.core.DefaultAtlasConversionService;
import io.atlasmap.core.DefaultAtlasPropertyStrategy;
import io.atlasmap.spi.AtlasConversionService;
import io.atlasmap.spi.AtlasPropertyType;
import io.atlasmap.v2.AtlasMapping;
import io.atlasmap.v2.AtlasModelFactory;
import io.atlasmap.v2.PropertyField;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DefaultAtlasPropertyStrategyTest {
    private DefaultAtlasPropertyStrategy propStrategy = null;

    @BeforeEach
    public void setUp() {
        this.propStrategy = new DefaultAtlasPropertyStrategy();
        this.propStrategy.setAtlasConversionService((AtlasConversionService)DefaultAtlasConversionService.getInstance());
    }

    @AfterEach
    public void tearDown() {
        this.propStrategy = null;
    }

    @Test
    public void testProcessPropertyFieldEnvironment() throws Exception {
        PropertyField propField = AtlasModelFactory.createPropertyField();
        propField.setName("PATH");
        this.propStrategy.readProperty(null, propField);
        Assertions.assertNotNull((Object)propField);
        Assertions.assertNotNull((Object)propField.getValue());
        Assertions.assertTrue((boolean)(propField.getValue() instanceof String));
        Assertions.assertTrue((boolean)((String)propField.getValue()).contains(File.pathSeparator));
    }

    @Test
    public void testProcessPropertyFieldEnvironmentDisabled() throws Exception {
        PropertyField propField = AtlasModelFactory.createPropertyField();
        propField.setName("PATH");
        this.propStrategy.setEnvironmentPropertiesEnabled(false);
        this.propStrategy.readProperty(null, propField);
        Assertions.assertNotNull((Object)propField);
        Assertions.assertNull((Object)propField.getValue());
    }

    @Test
    public void testProcessPropertyFieldNotFound() throws Exception {
        PropertyField propField = AtlasModelFactory.createPropertyField();
        propField.setName("XXXXXXXXXXXXXXXXXXXXX");
        this.propStrategy.readProperty(null, propField);
        Assertions.assertNotNull((Object)propField);
        Assertions.assertNull((Object)propField.getValue());
    }

    @Test
    public void testProcessPropertyFieldJavaSystem() throws Exception {
        PropertyField propField = AtlasModelFactory.createPropertyField();
        propField.setName("java.specification.version");
        this.propStrategy.readProperty(null, propField);
        Assertions.assertNotNull((Object)propField);
        Assertions.assertNotNull((Object)propField.getValue());
        Assertions.assertTrue((boolean)(propField.getValue() instanceof String));
        Assertions.assertTrue((Double.parseDouble((String)propField.getValue()) >= Double.parseDouble("1.8") ? 1 : 0) != 0, (String)((String)propField.getValue()));
    }

    @Test
    public void testProcessPropertyFieldJavaSystemDisabled() throws Exception {
        PropertyField propField = AtlasModelFactory.createPropertyField();
        propField.setName("java.specification.version");
        this.propStrategy.setSystemPropertiesEnabled(false);
        this.propStrategy.readProperty(null, propField);
        Assertions.assertNotNull((Object)propField);
        Assertions.assertNull((Object)propField.getValue());
    }

    @Test
    public void testProcessPropertyFieldDuplicateDefaultOrdering() throws Exception {
        PropertyField propField = AtlasModelFactory.createPropertyField();
        propField.setName("dupe-string");
        this.propStrategy.readProperty(AtlasTestData.generateAtlasSession(), propField);
        Assertions.assertNotNull((Object)propField);
        Assertions.assertNotNull((Object)propField.getValue());
        Assertions.assertTrue((boolean)(propField.getValue() instanceof String));
        Assertions.assertEquals((Object)"uh oh", (Object)propField.getValue());
    }

    @Test
    public void testProcessPropertyFieldDuplicateCustomOrdering() throws Exception {
        PropertyField propField = AtlasModelFactory.createPropertyField();
        propField.setName("dupe-string");
        this.propStrategy.setPropertyOrderValue(Arrays.asList(AtlasPropertyType.MAPPING_DEFINED_PROPERTIES.value(), AtlasPropertyType.RUNTIME_PROPERTIES.value()));
        this.propStrategy.readProperty(AtlasTestData.generateAtlasSession(), propField);
        Assertions.assertNotNull((Object)propField);
        Assertions.assertNotNull((Object)propField.getValue());
        Assertions.assertTrue((boolean)(propField.getValue() instanceof String));
        Assertions.assertEquals((Object)"whatup", (Object)propField.getValue());
    }

    @Test
    public void testProcessPropertyFieldNull() throws Exception {
        this.propStrategy.readProperty(null, null);
    }

    @Test
    public void testProcessPropertyFieldNullName() throws Exception {
        PropertyField propField = AtlasModelFactory.createPropertyField();
        this.propStrategy.readProperty(null, propField);
    }

    @Test
    public void testProcessPropertyFieldEmptyName() throws Exception {
        PropertyField propField = AtlasModelFactory.createPropertyField();
        propField.setName("");
        this.propStrategy.readProperty(null, propField);
    }

    @Test
    public void testProcessPropertyFieldMappingDefined() throws Exception {
        PropertyField propField = AtlasModelFactory.createPropertyField();
        propField.setName("prop-int");
        this.propStrategy.readProperty(AtlasTestData.generateAtlasSession(), propField);
        Assertions.assertNotNull((Object)propField);
        Assertions.assertNotNull((Object)propField.getValue());
        Assertions.assertTrue((boolean)(propField.getValue() instanceof Integer));
        Assertions.assertEquals((Integer)Integer.MIN_VALUE, (Integer)((Integer)propField.getValue()));
    }

    @Test
    public void testProcessPropertyFieldMappingDefinedDisabled() throws Exception {
        PropertyField propField = AtlasModelFactory.createPropertyField();
        propField.setName("prop-int");
        this.propStrategy.setMappingDefinedPropertiesEnabled(false);
        this.propStrategy.readProperty(null, propField);
        Assertions.assertNotNull((Object)propField);
        Assertions.assertNull((Object)propField.getValue());
    }

    @Test
    public void testProcessPropertyFieldMappingDefinedNullMapping() throws Exception {
        PropertyField propField = AtlasModelFactory.createPropertyField();
        propField.setName("prop-int");
        AtlasMapping mapping = AtlasTestData.generateAtlasMapping();
        mapping.setProperties(null);
        this.propStrategy.readProperty(null, propField);
        Assertions.assertNotNull((Object)propField);
        Assertions.assertNull((Object)propField.getValue());
    }

    @Test
    public void testProcessPropertyFieldMappingDefinedNullProperties() throws Exception {
        PropertyField propField = AtlasModelFactory.createPropertyField();
        propField.setName("prop-int");
        AtlasMapping mapping = AtlasTestData.generateAtlasMapping();
        mapping.setProperties(null);
        this.propStrategy.readProperty(null, propField);
        Assertions.assertNotNull((Object)propField);
        Assertions.assertNull((Object)propField.getValue());
    }

    @Test
    public void testProcessPropertyFieldMappingDefinedEmptyProperties() throws Exception {
        PropertyField propField = AtlasModelFactory.createPropertyField();
        propField.setName("prop-int");
        AtlasMapping mapping = AtlasTestData.generateAtlasMapping();
        mapping.getProperties().getProperty().clear();
        this.propStrategy.readProperty(null, propField);
        Assertions.assertNotNull((Object)propField);
        Assertions.assertNull((Object)propField.getValue());
    }

    @Test
    public void testProcessPropertyFieldMappingDefinedNullRuntime() throws Exception {
        PropertyField propField = AtlasModelFactory.createPropertyField();
        propField.setName("prop-int");
        this.propStrategy.readProperty(AtlasTestData.generateAtlasSession(), propField);
        Assertions.assertNotNull((Object)propField);
        Assertions.assertNotNull((Object)propField.getValue());
        Assertions.assertTrue((boolean)(propField.getValue() instanceof Integer));
        Assertions.assertEquals((Integer)Integer.MIN_VALUE, (Integer)((Integer)propField.getValue()));
    }

    @Test
    public void testProcessPropertyFieldMappingDefinedEmptyRuntime() throws Exception {
        PropertyField propField = AtlasModelFactory.createPropertyField();
        propField.setName("prop-int");
        this.propStrategy.readProperty(AtlasTestData.generateAtlasSession(), propField);
        Assertions.assertNotNull((Object)propField);
        Assertions.assertNotNull((Object)propField.getValue());
        Assertions.assertTrue((boolean)(propField.getValue() instanceof Integer));
        Assertions.assertEquals((Integer)Integer.MIN_VALUE, (Integer)((Integer)propField.getValue()));
    }

    @Test
    public void testProcessPropertyFieldMappingDefinedNoConversionService() throws Exception {
        PropertyField propField = AtlasModelFactory.createPropertyField();
        propField.setName("prop-int");
        this.propStrategy.setAtlasConversionService(null);
        this.propStrategy.readProperty(AtlasTestData.generateAtlasSession(), propField);
        Assertions.assertNotNull((Object)propField);
        Assertions.assertNotNull((Object)propField.getValue());
        Assertions.assertTrue((boolean)(propField.getValue() instanceof String));
        Assertions.assertEquals((Object)Integer.valueOf(Integer.MIN_VALUE).toString(), (Object)propField.getValue());
    }

    @Test
    public void testProcessPropertyFieldRuntime() throws Exception {
        PropertyField propField = AtlasModelFactory.createPropertyField();
        propField.setName("key-float");
        this.propStrategy.readProperty(AtlasTestData.generateAtlasSession(), propField);
        Assertions.assertNotNull((Object)propField);
        Assertions.assertNotNull((Object)propField.getValue());
        Assertions.assertTrue((boolean)(propField.getValue() instanceof Float));
        Assertions.assertEquals((Float)Float.valueOf(Float.MAX_VALUE), (Float)Float.valueOf(((Float)propField.getValue()).floatValue()));
    }

    @Test
    public void testProcessPropertyFieldRuntimeDisabled() throws Exception {
        PropertyField propField = AtlasModelFactory.createPropertyField();
        propField.setName("key-float");
        this.propStrategy.setRuntimePropertiesEnabled(false);
        this.propStrategy.readProperty(null, propField);
        Assertions.assertNotNull((Object)propField);
        Assertions.assertNull((Object)propField.getValue());
    }

    @Test
    public void testGetSetPropertyOrderValue() {
        List propTypes = this.propStrategy.getPropertyOrder();
        Assertions.assertNotNull((Object)propTypes);
        Assertions.assertEquals((Integer)4, (Integer)propTypes.size());
        Assertions.assertEquals((Object)AtlasPropertyType.RUNTIME_PROPERTIES, propTypes.get(0));
        Assertions.assertEquals((Object)AtlasPropertyType.JAVA_SYSTEM_PROPERTIES, propTypes.get(1));
        Assertions.assertEquals((Object)AtlasPropertyType.ENVIRONMENT_VARIABLES, propTypes.get(2));
        Assertions.assertEquals((Object)AtlasPropertyType.MAPPING_DEFINED_PROPERTIES, propTypes.get(3));
        this.propStrategy.setPropertyOrderValue(Arrays.asList(AtlasPropertyType.RUNTIME_PROPERTIES.value(), AtlasPropertyType.MAPPING_DEFINED_PROPERTIES.value()));
        propTypes = this.propStrategy.getPropertyOrder();
        Assertions.assertNotNull((Object)propTypes);
        Assertions.assertEquals((Integer)2, (Integer)propTypes.size());
        Assertions.assertEquals((Object)AtlasPropertyType.RUNTIME_PROPERTIES, propTypes.get(0));
        Assertions.assertEquals((Object)AtlasPropertyType.MAPPING_DEFINED_PROPERTIES, propTypes.get(1));
    }

    @Test
    public void testGetSetPropertyOrderValueIllegalValue() {
        List propTypes = this.propStrategy.getPropertyOrder();
        Assertions.assertNotNull((Object)propTypes);
        Assertions.assertTrue((propTypes.size() == 4 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)AtlasPropertyType.RUNTIME_PROPERTIES, propTypes.get(0));
        Assertions.assertEquals((Object)AtlasPropertyType.JAVA_SYSTEM_PROPERTIES, propTypes.get(1));
        Assertions.assertEquals((Object)AtlasPropertyType.ENVIRONMENT_VARIABLES, propTypes.get(2));
        Assertions.assertEquals((Object)AtlasPropertyType.MAPPING_DEFINED_PROPERTIES, propTypes.get(3));
        this.propStrategy.setPropertyOrderValue(Arrays.asList("foo", AtlasPropertyType.RUNTIME_PROPERTIES.value()));
        propTypes = this.propStrategy.getPropertyOrder();
        Assertions.assertNotNull((Object)propTypes);
        Assertions.assertEquals((Integer)1, (Integer)propTypes.size());
        Assertions.assertEquals((Object)AtlasPropertyType.RUNTIME_PROPERTIES, propTypes.get(0));
    }

    @Test
    public void testGetSetEnvironmentPropertiesEnabled() {
        Assertions.assertTrue((boolean)this.propStrategy.isEnvironmentPropertiesEnabled());
        this.propStrategy.setEnvironmentPropertiesEnabled(false);
        Assertions.assertFalse((boolean)this.propStrategy.isEnvironmentPropertiesEnabled());
    }

    @Test
    public void testGetSetSystemPropertiesEnabled() {
        Assertions.assertTrue((boolean)this.propStrategy.isSystemPropertiesEnabled());
        this.propStrategy.setSystemPropertiesEnabled(false);
        Assertions.assertFalse((boolean)this.propStrategy.isSystemPropertiesEnabled());
    }

    @Test
    public void testGetSetMappingDefinedPropertiesEnabled() {
        Assertions.assertTrue((boolean)this.propStrategy.isMappingDefinedPropertiesEnabled());
        this.propStrategy.setMappingDefinedPropertiesEnabled(false);
        Assertions.assertFalse((boolean)this.propStrategy.isMappingDefinedPropertiesEnabled());
    }

    @Test
    public void testGetSetRuntimePropertiesEnabled() {
        Assertions.assertTrue((boolean)this.propStrategy.isRuntimePropertiesEnabled());
        this.propStrategy.setRuntimePropertiesEnabled(false);
        Assertions.assertFalse((boolean)this.propStrategy.isRuntimePropertiesEnabled());
    }

    @Test
    public void testGetSetPropertyOrder() {
        List propTypes = this.propStrategy.getPropertyOrder();
        Assertions.assertNotNull((Object)propTypes);
        Assertions.assertTrue((propTypes.size() == 4 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)AtlasPropertyType.RUNTIME_PROPERTIES, propTypes.get(0));
        Assertions.assertEquals((Object)AtlasPropertyType.JAVA_SYSTEM_PROPERTIES, propTypes.get(1));
        Assertions.assertEquals((Object)AtlasPropertyType.ENVIRONMENT_VARIABLES, propTypes.get(2));
        Assertions.assertEquals((Object)AtlasPropertyType.MAPPING_DEFINED_PROPERTIES, propTypes.get(3));
        this.propStrategy.setPropertyOrder(Arrays.asList(AtlasPropertyType.RUNTIME_PROPERTIES, AtlasPropertyType.MAPPING_DEFINED_PROPERTIES));
        propTypes = this.propStrategy.getPropertyOrder();
        Assertions.assertNotNull((Object)propTypes);
        Assertions.assertTrue((propTypes.size() == 2 ? 1 : 0) != 0);
        Assertions.assertEquals((Object)AtlasPropertyType.RUNTIME_PROPERTIES, propTypes.get(0));
        Assertions.assertEquals((Object)AtlasPropertyType.MAPPING_DEFINED_PROPERTIES, propTypes.get(1));
    }

    @Test
    public void testGetSetAtlasConversionService() {
        this.propStrategy.setAtlasConversionService((AtlasConversionService)DefaultAtlasConversionService.getInstance());
        Assertions.assertNotNull((Object)this.propStrategy.getAtlasConversionService());
    }
}

